/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ListWithSelection;
import com.intellij.util.ui.ComboBoxTableCellRenderer;
import git4idea.GitUtil;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;

public class GitRebaseEditor
extends DialogWrapper {
    private JTable myCommitsTable;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JButton myViewButton;
    private JPanel myPanel;
    private final MyTableModel myTableModel;
    private final String myFile;
    private final Project myProject;
    private final VirtualFile myGitRoot;
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    protected GitRebaseEditor(final Project project, final VirtualFile gitRoot, String file) throws IOException {
        super(project, true);
        this.myProject = project;
        this.myGitRoot = gitRoot;
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("rebase.editor.title"));
        this.setOKButtonText(GitBundle.getString("rebase.editor.button"));
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            file = file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
        }
        this.myFile = file;
        this.myTableModel = new MyTableModel();
        this.myTableModel.load(file);
        this.myCommitsTable.setModel(this.myTableModel);
        this.myCommitsTable.setSelectionMode(1);
        JComboBox<GitRebaseEntry.Action> editorComboBox = new JComboBox<GitRebaseEntry.Action>();
        for (GitRebaseEntry.Action option : GitRebaseEntry.Action.values()) {
            editorComboBox.addItem(option);
        }
        TableColumn actionColumn = this.myCommitsTable.getColumnModel().getColumn(0);
        actionColumn.setCellEditor(new DefaultCellEditor(editorComboBox));
        actionColumn.setCellRenderer(ComboBoxTableCellRenderer.INSTANCE);
        this.myCommitsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitRebaseEditor.this.myViewButton.setEnabled(GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() == 1);
                ListSelectionModel selectionModel = GitRebaseEditor.this.myCommitsTable.getSelectionModel();
                GitRebaseEditor.this.myMoveUpButton.setEnabled(selectionModel.getMinSelectionIndex() > 0);
                GitRebaseEditor.this.myMoveDownButton.setEnabled(selectionModel.getMaxSelectionIndex() != -1 && selectionModel.getMaxSelectionIndex() < ((GitRebaseEditor)GitRebaseEditor.this).myTableModel.myEntries.size() - 1);
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                GitRebaseEntry entry = ((GitRebaseEditor)GitRebaseEditor.this).myTableModel.myEntries.get(row);
                GitUtil.showSubmittedFiles(project, entry.getCommit(), gitRoot, false, false);
            }
        });
        this.myMoveUpButton.addActionListener(new MoveUpDownActionListener(MoveDirection.up));
        this.myMoveDownButton.addActionListener(new MoveUpDownActionListener(MoveDirection.down));
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GitRebaseEditor.this.validateFields();
            }
        });
        this.init();
    }

    private void validateFields() {
        int i;
        List<GitRebaseEntry> entries = this.myTableModel.myEntries;
        if (entries.size() == 0) {
            this.setErrorText(GitBundle.getString("rebase.editor.invalid.entryset"));
            this.setOKActionEnabled(false);
            return;
        }
        for (i = 0; i < entries.size() && entries.get(i).getAction() == GitRebaseEntry.Action.skip; ++i) {
        }
        GitRebaseEntry.Action action = entries.get(i).getAction();
        if (i < entries.size() && (action == GitRebaseEntry.Action.squash || action == GitRebaseEntry.Action.fixup)) {
            this.setErrorText(GitBundle.message("rebase.editor.invalid.squash", StringUtil.toLowerCase((String)action.name())));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public void save() throws IOException {
        this.myTableModel.save(this.myFile);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.RebaseCommits";
    }

    public void cancel() throws IOException {
        this.myTableModel.cancel(this.myFile);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMoveUpButton = jButton3 = new JButton();
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.up.tooltip"));
        ((Component)jButton3).setEnabled(false);
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.up"));
        jPanel2.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMoveDownButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.down.tooltip"));
        ((Component)jButton2).setEnabled(false);
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.move.down"));
        jPanel2.add((Component)jButton2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myViewButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.view.tooltip"));
        ((Component)jButton).setEnabled(false);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.view"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myCommitsTable = jBTable;
        jBScrollPane.setViewportView((Component)jBTable);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.editor.message"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MoveUpDownActionListener
    implements ActionListener {
        private final MoveDirection direction;

        public MoveUpDownActionListener(MoveDirection direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRebaseEditor.this.myTableModel.moveRows(GitRebaseEditor.this.myCommitsTable.getSelectedRows(), this.direction);
        }
    }

    private static enum MoveDirection {
        up,
        down;


        public int offset() {
            if (this == up) {
                return -1;
            }
            return 1;
        }

        public int[] preprocessRowIndexes(int[] seletion) {
            int[] copy = (int[])seletion.clone();
            Arrays.sort(copy);
            if (this == up) {
                return copy;
            }
            return ArrayUtil.reverseArray((int[])copy);
        }
    }

    private static class ContiguousIntIntervalTracker {
        private Integer myMin = null;
        private Integer myMax = null;
        private static final int UNSET_VALUE = -1;

        private ContiguousIntIntervalTracker() {
        }

        public Integer getMin() {
            return this.myMin == null ? -1 : this.myMin;
        }

        public Integer getMax() {
            return this.myMax == null ? -1 : this.myMax;
        }

        public void track(int ... entries) {
            for (int entry : entries) {
                this.checkMax(entry);
                this.checkMin(entry);
            }
        }

        private void checkMax(int entry) {
            if (null == this.myMax || entry > this.myMax) {
                this.myMax = entry;
            }
        }

        private void checkMin(int entry) {
            if (null == this.myMin || entry < this.myMin) {
                this.myMin = entry;
            }
        }

        public boolean hasValues() {
            return null != this.myMin && null != this.myMax;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final int ACTION = 0;
        private static final int COMMIT = 1;
        private static final int SUBJECT = 2;
        final List<GitRebaseEntry> myEntries = new ArrayList<GitRebaseEntry>();
        private int[] myLastEditableSelectedRows = new int[0];

        private MyTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? ListWithSelection.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return GitBundle.getString("rebase.editor.action.column");
                }
                case 1: {
                    return GitBundle.getString("rebase.editor.commit.column");
                }
                case 2: {
                    return GitBundle.getString("rebase.editor.comment.column");
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + column);
        }

        @Override
        public int getRowCount() {
            return this.myEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new ListWithSelection(Arrays.asList(GitRebaseEntry.Action.values()), (Object)e.getAction());
                }
                case 1: {
                    return e.getCommit();
                }
                case 2: {
                    return e.getSubject();
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            if (ArrayUtil.indexOf((int[])this.myLastEditableSelectedRows, (int)rowIndex) > -1) {
                ContiguousIntIntervalTracker intervalBuilder = new ContiguousIntIntervalTracker();
                for (int lastEditableSelectedRow : this.myLastEditableSelectedRows) {
                    intervalBuilder.track(lastEditableSelectedRow);
                    this.setRowAction(aValue, lastEditableSelectedRow, columnIndex);
                }
                this.setSelection(intervalBuilder);
            } else {
                this.setRowAction(aValue, rowIndex, columnIndex);
            }
        }

        private void setSelection(ContiguousIntIntervalTracker intervalBuilder) {
            GitRebaseEditor.this.myCommitsTable.getSelectionModel().setSelectionInterval(intervalBuilder.getMin(), intervalBuilder.getMax());
        }

        private void setRowAction(Object aValue, int rowIndex, int columnIndex) {
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            e.setAction((GitRebaseEntry.Action)((Object)aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            this.myLastEditableSelectedRows = GitRebaseEditor.this.myCommitsTable.getSelectedRows();
            return columnIndex == 0;
        }

        public void load(String file) throws IOException {
            String encoding = GitConfigUtil.getLogEncoding(GitRebaseEditor.this.myProject, GitRebaseEditor.this.myGitRoot);
            StringScanner s = new StringScanner(FileUtil.loadFile((File)new File(file), (String)encoding));
            while (s.hasMoreData()) {
                if (s.isEol() || s.startsWith('#') || s.startsWith("noop")) {
                    s.nextLine();
                    continue;
                }
                String action = s.spaceToken();
                String hash = s.spaceToken();
                String comment = s.line();
                this.myEntries.add(new GitRebaseEntry(action, hash, comment));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(String file) throws IOException {
            String encoding = GitConfigUtil.getLogEncoding(GitRebaseEditor.this.myProject, GitRebaseEditor.this.myGitRoot);
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            try {
                for (GitRebaseEntry e : this.myEntries) {
                    if (e.getAction() == GitRebaseEntry.Action.skip) continue;
                    out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
                }
            }
            finally {
                out.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(String file) throws IOException {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            try {
                out.println("# rebase is cancelled");
            }
            finally {
                out.close();
            }
        }

        public void moveRows(int[] rows, MoveDirection direction) {
            GitRebaseEditor.this.myCommitsTable.removeEditor();
            ContiguousIntIntervalTracker selectionInterval = new ContiguousIntIntervalTracker();
            ContiguousIntIntervalTracker rowsUpdatedInterval = new ContiguousIntIntervalTracker();
            for (int row : direction.preprocessRowIndexes(rows)) {
                int targetIndex = row + direction.offset();
                this.assertIndexInRange(row, targetIndex);
                Collections.swap(this.myEntries, row, targetIndex);
                rowsUpdatedInterval.track(targetIndex, row);
                selectionInterval.track(targetIndex);
            }
            if (selectionInterval.hasValues()) {
                this.setSelection(selectionInterval);
                this.fireTableRowsUpdated(rowsUpdatedInterval.getMin(), rowsUpdatedInterval.getMax());
            }
        }

        private void assertIndexInRange(int ... rowIndexes) {
            for (int rowIndex : rowIndexes) {
                assert (rowIndex >= 0);
                assert (rowIndex < this.myEntries.size());
            }
        }
    }
}

