/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitUntrackedFilesHolder;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @Nullable
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    protected GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull GitPlatformFacade facade, @NotNull Project project, @NotNull Disposable parentDisposable, boolean light) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        super(project, rootDir, parentDisposable);
        this.myPlatformFacade = facade;
        this.myGitDir = GitUtil.findGitDir(rootDir);
        assert (this.myGitDir != null) : ".git directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new GitRepositoryReader(VfsUtilCore.virtualToIoFile((VirtualFile)this.myGitDir));
        if (!light) {
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
        } else {
            this.myUntrackedFilesHolder = null;
        }
        this.update();
    }

    @NotNull
    public static GitRepository getLightInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Disposable parentDisposable) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/repo/GitRepositoryImpl", "getLightInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "getLightInstance"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/repo/GitRepositoryImpl", "getLightInstance"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "git4idea/repo/GitRepositoryImpl", "getLightInstance"));
        }
        GitRepositoryImpl gitRepositoryImpl = new GitRepositoryImpl(root, facade, project, parentDisposable, true);
        if (gitRepositoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getLightInstance"));
        }
        return gitRepositoryImpl;
    }

    @NotNull
    public static GitRepository getFullInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Disposable parentDisposable) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/repo/GitRepositoryImpl", "getFullInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "getFullInstance"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/repo/GitRepositoryImpl", "getFullInstance"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "git4idea/repo/GitRepositoryImpl", "getFullInstance"));
        }
        GitRepositoryImpl repository = new GitRepositoryImpl(root, facade, project, parentDisposable, false);
        repository.myUntrackedFilesHolder.setupVfsListener(project);
        repository.setupUpdater();
        GitRepositoryImpl gitRepositoryImpl = repository;
        if (gitRepositoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getFullInstance"));
        }
        return gitRepositoryImpl;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    @NotNull
    public VirtualFile getGitDir() {
        VirtualFile virtualFile = this.myGitDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getGitDir"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.myUntrackedFilesHolder;
        if (gitUntrackedFilesHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getUntrackedFilesHolder"));
        }
        return gitUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        GitRepoInfo gitRepoInfo = this.myInfo;
        if (gitRepoInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getInfo"));
        }
        return gitRepoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getState"));
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @Nullable
    public AbstractVcs getVcs() {
        return GitVcs.getInstance(this.getProject());
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        GitBranchesCollection gitBranchesCollection = new GitBranchesCollection(info.getLocalBranches(), info.getRemoteBranches());
        if (gitBranchesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getBranches"));
        }
        return gitBranchesCollection;
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        Collection<GitRemote> collection = this.myInfo.getRemotes();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getRemotes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Collection<GitBranchTrackInfo> collection = this.myInfo.getBranchTrackInfos();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getBranchTrackInfos"));
        }
        return collection;
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public void update() {
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyListeners(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        File configFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getGitDir()), "config");
        GitConfig config = GitConfig.read(this.myPlatformFacade, configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches(), state.getRemoteBranches());
        GitRepoInfo gitRepoInfo = new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), remotes, state.getLocalBranches(), state.getRemoteBranches(), trackInfos);
        if (gitRepoInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "readRepoInfo"));
        }
        return gitRepoInfo;
    }

    private static void notifyListeners(@NotNull GitRepository repository, @Nullable GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/repo/GitRepositoryImpl", "notifyListeners"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "git4idea/repo/GitRepositoryImpl", "notifyListeners"));
        }
        if (Disposer.isDisposed((Disposable)repository.getProject())) {
            return;
        }
        if (!info.equals(previousInfo)) {
            ((GitRepositoryChangeListener)repository.getProject().getMessageBus().syncPublisher(GIT_REPO_CHANGE)).repositoryChanged(repository);
        }
    }

    @NotNull
    public String toLogString() {
        String string = String.format("GitRepository " + this.getRoot() + " : " + this.myInfo, new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "toLogString"));
        }
        return string;
    }
}

