/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.DownloadBitmapCommand;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewBitmapAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        final DataContext actionContext = e.getDataContext();
        DebuggerTreeNodeImpl node = ViewBitmapAction.getSelectedNode((DataContext)actionContext);
        if (node == null) {
            return;
        }
        Value bitmapValue = ViewBitmapAction.getValue(node);
        if (bitmapValue == null) {
            return;
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(actionContext);
        if (project == null) {
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        if (debuggerManager == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = debuggerManager.getContext();
        if (debuggerContext == null || debuggerContext.getDebuggerSession() == null) {
            return;
        }
        ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, project);
        final String variableName = node.getText() == null ? "Bitmap" : node.getText().toString();
        DownloadBitmapCommand.CompletionCallback onComplete = new DownloadBitmapCommand.CompletionCallback(){

            @Override
            public void bitmapDownloaded(final @NotNull BufferedImage image) {
                if (image == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/run/ViewBitmapAction$1", "bitmapDownloaded"));
                }
                DebuggerInvocationUtil.swingInvokeLater((Project)project, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JComponent imageComponent = new JComponent(){

                            @Override
                            protected void paintComponent(Graphics g) {
                                g.drawImage(image, 0, 0, null);
                            }
                        };
                        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(imageComponent, null).setProject(project).setTitle(variableName).setResizable(true).setMovable(true).setFocusable(true).setMinSize(new Dimension(image.getWidth(), image.getHeight())).setShowBorder(true).createPopup();
                        popup.show(JBPopupFactory.getInstance().guessBestPopupLocation(actionContext));
                    }
                });
            }

            @Override
            public void error(final @NotNull String message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ViewBitmapAction$1", "error"));
                }
                DebuggerInvocationUtil.swingInvokeLater((Project)project, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JBPopup popup = JBPopupFactory.getInstance().createMessage(message);
                        popup.show(JBPopupFactory.getInstance().guessBestPopupLocation(actionContext));
                    }
                });
            }
        };
        DownloadBitmapCommand downloadBitmapCommand = new DownloadBitmapCommand(bitmapValue, debuggerContext, onComplete, progressWindow);
        progressWindow.setTitle("Retrieving Bitmap...");
        debuggerContext.getDebugProcess().getManagerThread().startProgress((DebuggerCommandImpl)downloadBitmapCommand, progressWindow);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext actionContext = e.getDataContext();
        DebuggerTreeNodeImpl node = ViewBitmapAction.getSelectedNode((DataContext)actionContext);
        Value value = ViewBitmapAction.getValue(node);
        if (!(value instanceof ObjectReference)) {
            presentation.setVisible(false);
            return;
        }
        if (!DownloadBitmapCommand.isSupportedBitmap(value)) {
            presentation.setVisible(false);
        } else {
            presentation.setText("View Bitmap");
            presentation.setVisible(true);
            presentation.setEnabled(true);
        }
    }

    @Nullable
    private static Value getValue(@Nullable DebuggerTreeNodeImpl node) {
        if (node == null) {
            return null;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptor)) {
            return null;
        }
        return ((ValueDescriptor)descriptor).getValue();
    }
}

