/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.SdkAddonsListConstants;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.sdklib.repository.remote.RemoteSdk;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.welcome.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.FirstRunWizardHost;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.InstallerData;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JRootPane;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidStudioWelcomeScreenProvider
implements WelcomeScreenProvider {
    public static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";
    private static boolean ourWasShown = false;

    @Nullable
    public static FirstRunWizardMode getWizardMode() {
        AndroidFirstRunPersistentData persistentData = AndroidFirstRunPersistentData.getInstance();
        if (AndroidStudioWelcomeScreenProvider.isHandoff(persistentData)) {
            return FirstRunWizardMode.INSTALL_HANDOFF;
        }
        if (!persistentData.isSdkUpToDate()) {
            return FirstRunWizardMode.NEW_INSTALL;
        }
        if (DefaultSdks.getEligibleAndroidSdks().isEmpty()) {
            return FirstRunWizardMode.MISSING_SDK;
        }
        return null;
    }

    private static boolean isHandoff(AndroidFirstRunPersistentData persistentData) {
        return InstallerData.exists() && (!persistentData.isSdkUpToDate() || !persistentData.isSameTimestamp(InstallerData.get().getTimestamp()));
    }

    private static boolean isWizardDisabled() {
        return AndroidPlugin.isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
    }

    @NotNull
    private static ConnectionState checkInternetConnection() {
        CommonProxy.isInstalledAssertion();
        ConnectionState result = null;
        while (result == null) {
            try {
                HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(SdkAddonsListConstants.URL_ADDON_LIST);
                connection.connect();
                connection.disconnect();
                result = ConnectionState.OK;
            }
            catch (IOException e) {
                result = AndroidStudioWelcomeScreenProvider.promptToRetryFailedConnection();
            }
        }
        ConnectionState connectionState = result;
        if (connectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/AndroidStudioWelcomeScreenProvider", "checkInternetConnection"));
        }
        return connectionState;
    }

    @Nullable
    private static ConnectionState promptToRetryFailedConnection() {
        final AtomicReference atomicBoolean = Atomics.newReference();
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                atomicBoolean.set(AndroidStudioWelcomeScreenProvider.promptUserForProxy());
            }
        }, application.getAnyModalityState());
        return (ConnectionState)((Object)atomicBoolean.get());
    }

    @Nullable
    private static ConnectionState promptUserForProxy() {
        int selection = Messages.showDialog((String)"Unable to access Android SDK add-on list", (String)"Android Studio First Run", (String[])new String[]{"Setup Proxy", "Cancel"}, (int)1, (Icon)Messages.getErrorIcon());
        if (selection == 0) {
            HttpConfigurable.editConfigurable(null);
            return null;
        }
        return ConnectionState.NO_CONNECTION;
    }

    @Nullable
    public WelcomeScreen createWelcomeScreen(JRootPane rootPane) {
        Multimap remotePackages = (Multimap)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Multimap<PkgType, RemotePkgInfo>, RuntimeException>(){

            public Multimap<PkgType, RemotePkgInfo> compute() throws RuntimeException {
                return AndroidStudioWelcomeScreenProvider.this.fetchPackages();
            }
        }, "Fetching Android SDK component information", false, null);
        FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
        assert (wizardMode != null);
        ourWasShown = true;
        return new FirstRunWizardHost(wizardMode, (Multimap<PkgType, RemotePkgInfo>)remotePackages);
    }

    private Multimap<PkgType, RemotePkgInfo> fetchPackages() {
        ConnectionState connectionState = AndroidStudioWelcomeScreenProvider.checkInternetConnection();
        switch (connectionState) {
            case OK: {
                break;
            }
            case NO_CONNECTION: {
                return ImmutableMultimap.of();
            }
            default: {
                throw new IllegalArgumentException(connectionState.name());
            }
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        RemoteSdk remoteSdk = new RemoteSdk(new SettingsController((ILogger)new LogWrapper(Logger.getInstance(this.getClass()))));
        SdkSources sdkSources = remoteSdk.fetchSources(86400000L, (ILogger)new NullLogger());
        return remoteSdk.fetch(sdkSources, (ILogger)new NullLogger());
    }

    public boolean isAvailable() {
        return !ourWasShown && !AndroidStudioWelcomeScreenProvider.isWizardDisabled() && AndroidStudioWelcomeScreenProvider.getWizardMode() != null;
    }

    private static enum ConnectionState {
        OK,
        NO_CONNECTION;

    }
}

