/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.welcome.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.AndroidSdk;
import com.android.tools.idea.welcome.AndroidVirtualDevice;
import com.android.tools.idea.welcome.ComponentInstaller;
import com.android.tools.idea.welcome.DownloadOperation;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.Haxm;
import com.android.tools.idea.welcome.InstallComponentsOperation;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallOperation;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.InstallationCancelledException;
import com.android.tools.idea.welcome.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.LinuxHaxmInfoStep;
import com.android.tools.idea.welcome.LongRunningOperationPath;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.welcome.SdkComponentsStep;
import com.android.tools.idea.welcome.UnpackOperation;
import com.android.tools.idea.welcome.WizardException;
import com.android.tools.idea.welcome.installoperations.CheckSdkOperation;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    public static final ScopedStateStore.Key<Boolean> KEY_CUSTOM_INSTALL = ScopedStateStore.createKey("custom.install", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final AndroidVersion LATEST_ANDROID_VERSION = new AndroidVersion(21, null);
    private static final ScopedStateStore.Key<String> KEY_SDK_INSTALL_LOCATION = ScopedStateStore.createKey("download.sdk.location", ScopedStateStore.Scope.PATH, String.class);
    private final ProgressStep myProgressStep;
    @NotNull
    private final FirstRunWizardMode myMode;
    @Nullable
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;
    @NotNull
    private final File mySdkLocation;
    private InstallableComponent[] myComponents;
    private InstallationTypeWizardStep myInstallationTypeWizardStep;
    private SdkComponentsStep mySdkComponentsStep;

    public InstallComponentsPath(@NotNull ProgressStep progressStep, @NotNull FirstRunWizardMode mode, @NotNull File sdkLocation, @Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/InstallComponentsPath", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/InstallComponentsPath", "<init>"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/InstallComponentsPath", "<init>"));
        }
        this.myProgressStep = progressStep;
        this.myMode = mode;
        this.mySdkLocation = sdkLocation;
        this.myRemotePackages = remotePackages;
    }

    private static InstallableComponent[] createComponents(@NotNull FirstRunWizardMode reason, boolean createAvd) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/welcome/InstallComponentsPath", "createComponents"));
        }
        AndroidSdk androidSdk = new AndroidSdk();
        ArrayList components = Lists.newArrayList();
        components.add(androidSdk);
        if (Haxm.canRun() && reason == FirstRunWizardMode.NEW_INSTALL) {
            components.add(new Haxm(KEY_CUSTOM_INSTALL));
        }
        if (createAvd) {
            components.add(new AndroidVirtualDevice());
        }
        return components.toArray(new InstallableComponent[components.size()]);
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    private static boolean hasPlatformsDir(@Nullable File[] files) {
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!InstallComponentsPath.isPlatformsDir(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPlatformsDir(File file) {
        return file.isDirectory() && file.getName().equalsIgnoreCase("platforms");
    }

    @NotNull
    private static File getSdkRoot(@NotNull File expandedLocation) {
        if (expandedLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandedLocation", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
        }
        File[] files = expandedLocation.listFiles();
        if (InstallComponentsPath.hasPlatformsDir(files)) {
            File file = expandedLocation;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
            }
            return file;
        }
        if (files != null) {
            for (File file : files) {
                if (!InstallComponentsPath.hasPlatformsDir(file.listFiles())) continue;
                File file2 = file;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
                }
                return file2;
            }
        }
        File file = expandedLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
        }
        return file;
    }

    @NotNull
    @VisibleForTesting
    static InstallOperation<File, File> downloadAndUnzipSdkSeed(@NotNull InstallContext context, @NotNull File destination, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        double DOWNLOAD_OPERATION_PROGRESS_SHARE = progressShare * 0.8;
        double UNZIP_OPERATION_PROGRESS_SHARE = progressShare * 0.15;
        double MOVE_OPERATION_PROGRESS_SHARE = progressShare - DOWNLOAD_OPERATION_PROGRESS_SHARE - UNZIP_OPERATION_PROGRESS_SHARE;
        DownloadOperation download = new DownloadOperation(context, FirstRunWizardDefaults.getSdkDownloadUrl(), DOWNLOAD_OPERATION_PROGRESS_SHARE);
        UnpackOperation unpack = new UnpackOperation(context, UNZIP_OPERATION_PROGRESS_SHARE);
        MoveSdkOperation move = new MoveSdkOperation(context, destination, MOVE_OPERATION_PROGRESS_SHARE);
        InstallOperation<File, File> installOperation = download.then(unpack).then(move);
        if (installOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        return installOperation;
    }

    private static boolean existsAndIsVisible(DynamicWizardStep step) {
        return step != null && step.isStepVisible();
    }

    @Nullable
    private File getHandoffAndroidSdkSource() {
        File androidSrc = this.myMode.getAndroidSrc();
        if (androidSrc != null) {
            File[] files = androidSrc.listFiles();
            if (androidSrc.isDirectory() && files != null && files.length > 0) {
                return androidSrc;
            }
        }
        return null;
    }

    private InstallOperation<File, File> createInitSdkOperation(InstallContext installContext, File destination, double progressRatio) {
        SdkManager manager;
        File handoffSource = this.getHandoffAndroidSdkSource();
        if (handoffSource != null) {
            return new MergeOperation(handoffSource, installContext, progressRatio);
        }
        if (destination.isDirectory() && (manager = SdkManager.createManager((String)destination.getAbsolutePath(), (ILogger)new NullLogger())) != null) {
            return InstallOperation.wrap(installContext, new ReturnValue(), 0.0);
        }
        return InstallComponentsPath.downloadAndUnzipSdkSeed(installContext, destination, progressRatio);
    }

    @Override
    protected void init() {
        boolean createAvd = this.myMode.shouldCreateAvd();
        if (this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            this.myInstallationTypeWizardStep = new InstallationTypeWizardStep(KEY_CUSTOM_INSTALL);
            this.addStep(this.myInstallationTypeWizardStep);
        }
        this.myState.put(KEY_SDK_INSTALL_LOCATION, this.mySdkLocation.getAbsolutePath());
        this.myComponents = InstallComponentsPath.createComponents(this.myMode, createAvd);
        this.mySdkComponentsStep = new SdkComponentsStep(this.myComponents, KEY_CUSTOM_INSTALL, KEY_SDK_INSTALL_LOCATION, this.myMode);
        this.addStep(this.mySdkComponentsStep);
        for (InstallableComponent component : this.myComponents) {
            component.init(this.myState, this.myProgressStep);
            for (DynamicWizardStep step : component.createSteps()) {
                this.addStep(step);
            }
        }
        if (SystemInfo.isLinux && this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            this.addStep(new LinuxHaxmInfoStep());
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (modified.contains(KEY_CUSTOM_INSTALL) || modified.contains(KEY_SDK_INSTALL_LOCATION) || this.containsComponentVisibilityKey(modified)) {
            String sdkPath = this.myState.get(KEY_SDK_INSTALL_LOCATION);
            SdkManager manager = null;
            if (sdkPath != null) {
                manager = SdkManager.createManager((String)sdkPath, (ILogger)new NullLogger());
            }
            ArrayList<String> installIds = new ComponentInstaller(this.getSelectedComponents(), this.myRemotePackages).getPackagesToInstall(manager);
            List<IPkgDesc> packages = this.getPackagesList(installIds);
            this.myState.put(WizardConstants.INSTALL_REQUESTS_KEY, packages);
        }
    }

    @NotNull
    private List<IPkgDesc> getPackagesList(@NotNull Collection<String> installIds) {
        if (installIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installIds", "com/android/tools/idea/welcome/InstallComponentsPath", "getPackagesList"));
        }
        if (this.myRemotePackages != null) {
            ImmutableSet ids = ImmutableSet.copyOf(installIds);
            ImmutableList.Builder packages = ImmutableList.builder();
            for (RemotePkgInfo remotePkgInfo : this.myRemotePackages.values()) {
                IPkgDesc desc = remotePkgInfo.getDesc();
                if (!ids.contains((Object)desc.getInstallId())) continue;
                packages.add((Object)desc);
            }
            ImmutableList immutableList = packages.build();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getPackagesList"));
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getPackagesList"));
        }
        return immutableList;
    }

    private boolean containsComponentVisibilityKey(@NotNull Set<ScopedStateStore.Key> modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/welcome/InstallComponentsPath", "containsComponentVisibilityKey"));
        }
        if (this.myComponents == null) {
            return false;
        }
        for (InstallableComponent component : this.myComponents) {
            if (!modified.contains(component.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup Android Studio Components" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getPathName"));
        }
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INIT_SDK_OPERATION_PROGRESS_SHARE = 0.3;
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 0.7;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File destination = this.getDestination();
        InstallOperation<File, File> initialize = this.createInitSdkOperation(installContext, destination, 0.3);
        List<InstallableComponent> selectedComponents = this.getSelectedComponents();
        CheckSdkOperation checkSdk = new CheckSdkOperation(installContext);
        InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, this.myRemotePackages, 0.7);
        SetPreference setPreference = new SetPreference(this.myMode.getInstallerTimestamp());
        try {
            initialize.then(checkSdk).then(install).then(setPreference).then(new ConfigureComponents(installContext, selectedComponents)).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private List<InstallableComponent> getSelectedComponents() {
        boolean customInstall = this.myState.getNotNull(KEY_CUSTOM_INSTALL, true);
        ArrayList selectedOperations = Lists.newArrayListWithCapacity((int)this.myComponents.length);
        for (InstallableComponent component : this.myComponents) {
            if (customInstall && !this.myState.getNotNull(component.getKey(), true).booleanValue()) continue;
            selectedOperations.add(component);
        }
        return selectedOperations;
    }

    @NotNull
    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        File file = destination;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getDestination"));
        }
        return file;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean showsStep() {
        return this.isPathVisible() && (InstallComponentsPath.existsAndIsVisible(this.myInstallationTypeWizardStep) || InstallComponentsPath.existsAndIsVisible(this.mySdkComponentsStep));
    }

    private static class ConfigureComponents
    implements Function<File, File> {
        private final InstallContext myInstallContext;
        private final Collection<? extends InstallableComponent> mySelectedComponents;

        public ConfigureComponents(InstallContext installContext, Collection<? extends InstallableComponent> selectedComponents) {
            this.myInstallContext = installContext;
            this.mySelectedComponents = selectedComponents;
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            for (InstallableComponent installableComponent : this.mySelectedComponents) {
                installableComponent.configure(this.myInstallContext, input);
            }
            return input;
        }
    }

    private static class SetPreference
    implements Function<File, File> {
        @Nullable
        private final String myInstallerTimestamp;

        public SetPreference(@Nullable String installerTimestamp) {
            this.myInstallerTimestamp = installerTimestamp;
        }

        public File apply(final @Nullable File input) {
            assert (input != null);
            final Application application = ApplicationManager.getApplication();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            DefaultSdks.setDefaultAndroidHome(input, null);
                            AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(SetPreference.this.myInstallerTimestamp);
                        }
                    });
                }
            }, application.getAnyModalityState());
            return input;
        }
    }

    private static class ReturnValue
    implements Function<File, File> {
        private ReturnValue() {
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            return input;
        }
    }

    private static class MoveSdkOperation
    extends InstallOperation<File, File> {
        @NotNull
        private final File myDestination;

        public MoveSdkOperation(@NotNull InstallContext context, @NotNull File destination, double progressShare) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "<init>"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "<init>"));
            }
            super(context, progressShare);
            this.myDestination = destination;
        }

        @Override
        @NotNull
        protected File perform(@NotNull ProgressIndicator indicator, @NotNull File file) throws WizardException {
            File file2;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            indicator.setText("Moving downloaded SDK");
            indicator.start();
            try {
                File root = InstallComponentsPath.getSdkRoot(file);
                if (!root.renameTo(this.myDestination)) {
                    FileUtil.copyDir((File)root, (File)this.myDestination);
                    FileUtil.delete((File)root);
                }
                File file3 = this.myDestination;
                file2 = file3;
            }
            catch (IOException e) {
                throw new WizardException("Unable to move Android SDK", e);
            }
            finally {
                indicator.setFraction(1.0);
                indicator.stop();
            }
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            return file2;
        }

        @Override
        public void cleanup(@NotNull File result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/InstallComponentsPath$MoveSdkOperation", "cleanup"));
            }
        }
    }

    private static class MergeOperation
    extends InstallOperation<File, File> {
        private final File myRepo;
        private final InstallContext myContext;
        private boolean myRepoWasMerged = false;

        public MergeOperation(File repo, InstallContext context, double progressRatio) {
            super(context, progressRatio);
            this.myRepo = repo;
            this.myContext = context;
        }

        @Override
        @NotNull
        protected File perform(@NotNull ProgressIndicator indicator, @NotNull File destination) throws WizardException {
            File file;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/InstallComponentsPath$MergeOperation", "perform"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath$MergeOperation", "perform"));
            }
            indicator.setText("Installing Android SDK");
            try {
                FileUtil.ensureExists((File)destination);
                if (!FileUtil.filesEqual((File)destination.getCanonicalFile(), (File)this.myRepo.getCanonicalFile())) {
                    SdkMerger.mergeSdks(this.myRepo, destination, indicator);
                    this.myRepoWasMerged = true;
                }
                this.myContext.print(String.format("Android SDK was installed to %1$s\n", destination), ConsoleViewContentType.SYSTEM_OUTPUT);
                File file2 = destination;
                file = file2;
            }
            catch (IOException e) {
                throw new WizardException(e.getMessage(), e);
            }
            finally {
                indicator.stop();
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath$MergeOperation", "perform"));
            }
            return file;
        }

        @Override
        public void cleanup(@NotNull File result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/InstallComponentsPath$MergeOperation", "cleanup"));
            }
            if (this.myRepoWasMerged && this.myRepo.exists()) {
                FileUtil.delete((File)this.myRepo);
            }
        }
    }
}

