/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;

public class ClassLoaderVisitor {
    private final ClassLoader stopAt = ClassLoader.getSystemClassLoader() == null ? null : ClassLoader.getSystemClassLoader().getParent();

    public void visit(ClassLoader classLoader) {
        if (classLoader == this.stopAt) {
            this.visitSpec(ClassLoaderSpec.SYSTEM_CLASS_LOADER);
            return;
        }
        if (classLoader instanceof ClassLoaderHierarchy) {
            ((ClassLoaderHierarchy)((Object)classLoader)).visit(this);
        } else {
            if (classLoader instanceof URLClassLoader) {
                this.visitClassPath(((URLClassLoader)classLoader).getURLs());
            }
            if (classLoader.getParent() != null) {
                this.visitParent(classLoader.getParent());
            }
        }
    }

    public void visitSpec(ClassLoaderSpec spec) {
    }

    public void visitClassPath(URL[] classPath) {
    }

    public void visitParent(ClassLoader classLoader) {
        this.visit(classLoader);
    }
}

