/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.listeners.CoverageListener;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.CoverageConfigurable;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageJavaRunConfigurationExtension
extends RunConfigurationExtension {
    public void attachToProcess(@NotNull RunConfigurationBase configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "attachToProcess"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "attachToProcess"));
        }
        CoverageDataManager.getInstance(configuration.getProject()).attachToProcess(handler, configuration, runnerSettings);
    }

    @Nullable
    public SettingsEditor createEditor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "createEditor"));
        }
        return new CoverageConfigurable(configuration);
    }

    public String getEditorTitle() {
        return CoverageEngine.getEditorTitle();
    }

    @NotNull
    public String getSerializationId() {
        if ("coverage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "getSerializationId"));
        }
        return "coverage";
    }

    public void updateJavaParameters(RunConfigurationBase configuration, JavaParameters params, RunnerSettings runnerSettings) {
        if (!this.isApplicableFor(configuration)) {
            return;
        }
        JavaCoverageEnabledConfiguration coverageConfig = JavaCoverageEnabledConfiguration.getFrom(configuration);
        coverageConfig.setCurrentCoverageSuite(null);
        CoverageRunner coverageRunner = coverageConfig.getCoverageRunner();
        if (runnerSettings instanceof CoverageRunnerData && coverageRunner != null) {
            CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(configuration.getProject());
            coverageConfig.setCurrentCoverageSuite(coverageDataManager.addCoverageSuite(coverageConfig));
            coverageConfig.appendCoverageArgument(configuration, (SimpleJavaParameters)params);
            Sdk jdk = params.getJdk();
            if (jdk != null && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_7) && coverageRunner instanceof JavaCoverageRunner && !((JavaCoverageRunner)coverageRunner).isJdk7Compatible()) {
                Notifications.Bus.notify((Notification)new Notification("Coverage", "Coverage instrumentation is not fully compatible with JDK 7", coverageRunner.getPresentableName() + " coverage instrumentation can lead to java.lang.VerifyError errors with JDK 7. If so, please try IDEA coverage runner.", NotificationType.WARNING));
            }
        }
    }

    public void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "readExternal"));
        }
        if (!this.isApplicableFor(runConfiguration)) {
            return;
        }
        JavaCoverageEnabledConfiguration.getFrom(runConfiguration).readExternal(element);
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "writeExternal"));
        }
        if (!this.isApplicableFor(runConfiguration)) {
            return;
        }
        JavaCoverageEnabledConfiguration.getFrom(runConfiguration).writeExternal(element);
    }

    public void extendCreatedConfiguration(@NotNull RunConfigurationBase runJavaConfiguration, @NotNull Location location) {
        if (runJavaConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runJavaConfiguration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "extendCreatedConfiguration"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "extendCreatedConfiguration"));
        }
        JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(runJavaConfiguration);
        assert (coverageEnabledConfiguration != null);
        if (runJavaConfiguration instanceof CommonJavaRunConfigurationParameters) {
            coverageEnabledConfiguration.setUpCoverageFilters(((CommonJavaRunConfigurationParameters)runJavaConfiguration).getRunClass(), ((CommonJavaRunConfigurationParameters)runJavaConfiguration).getPackage());
        }
    }

    public void cleanUserData(RunConfigurationBase runConfiguration) {
        runConfiguration.putCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY, null);
    }

    public void validateConfiguration(@NotNull RunConfigurationBase runJavaConfiguration, boolean isExecution) throws RuntimeConfigurationException {
        if (runJavaConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runJavaConfiguration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "validateConfiguration"));
        }
    }

    public RefactoringElementListener wrapElementListener(PsiElement element, RunConfigurationBase configuration, RefactoringElementListener listener) {
        if (!this.isApplicableFor(configuration)) {
            return listener;
        }
        JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(configuration);
        if (coverageEnabledConfiguration != null) {
            Project project = configuration.getProject();
            ClassFilter[] patterns = coverageEnabledConfiguration.getCoveragePatterns();
            Object[] filters = CoverageJavaRunConfigurationExtension.getFilters(coverageEnabledConfiguration);
            if (patterns != null) {
                assert (filters != null);
                if (element instanceof PsiClass) {
                    MyClassAccessor accessor;
                    RefactoringElementListener classListener;
                    int idx = ArrayUtil.find((Object[])filters, (Object)((PsiClass)element).getQualifiedName());
                    if (idx > -1 && (classListener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)(accessor = new MyClassAccessor(project, patterns, idx, (String[])filters)))) != null) {
                        listener = CoverageJavaRunConfigurationExtension.appendListener(listener, classListener);
                    }
                } else if (element instanceof PsiPackage) {
                    String qualifiedName = ((PsiPackage)element).getQualifiedName();
                    int filtersLength = filters.length;
                    for (int i = 0; i < filtersLength; ++i) {
                        RefactoringElementListener packageListener;
                        if (!((String)filters[i]).startsWith(qualifiedName + ".") || (packageListener = ((String)filters[i]).endsWith("*") ? RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), (RefactoringListeners.Accessor)new MyPackageAccessor(project, patterns, i, (String[])filters)) : RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new MyClassAccessor(project, patterns, i, (String[])filters))) == null) continue;
                        listener = CoverageJavaRunConfigurationExtension.appendListener(listener, packageListener);
                    }
                }
            }
        }
        return listener;
    }

    @Nullable
    private static String[] getFilters(JavaCoverageEnabledConfiguration coverageEnabledConfiguration) {
        ClassFilter[] patterns = coverageEnabledConfiguration.getCoveragePatterns();
        if (patterns != null) {
            ArrayList<String> filters = new ArrayList<String>();
            for (ClassFilter classFilter : patterns) {
                filters.add(classFilter.getPattern());
            }
            return ArrayUtil.toStringArray(filters);
        }
        return null;
    }

    private static RefactoringElementListener appendListener(RefactoringElementListener listener, RefactoringElementListener classOrPackageListener) {
        if (listener == null) {
            listener = new RefactoringElementListenerComposite();
        } else if (!(listener instanceof RefactoringElementListenerComposite)) {
            RefactoringElementListenerComposite composite = new RefactoringElementListenerComposite();
            composite.addListener(listener);
            listener = composite;
        }
        ((RefactoringElementListenerComposite)listener).addListener(classOrPackageListener);
        return listener;
    }

    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener, RunnerSettings runnerSettings) {
        if (listener instanceof CoverageListener) {
            if (!(runnerSettings instanceof CoverageRunnerData)) {
                return true;
            }
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
            return !(coverageEnabledConfiguration.getCoverageRunner() instanceof IDEACoverageRunner) || !coverageEnabledConfiguration.isTrackPerTestCoverage() || coverageEnabledConfiguration.isSampling();
        }
        return false;
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/coverage/CoverageJavaRunConfigurationExtension", "isApplicableFor"));
        }
        return CoverageEnabledConfiguration.isApplicableTo(configuration);
    }

    private static class MyAccessor {
        private final Project myProject;
        private final ClassFilter[] myPatterns;
        private final int myIdx;
        private final String[] myFilters;

        private MyAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            this.myProject = project;
            this.myPatterns = patterns;
            this.myIdx = idx;
            this.myFilters = filters;
        }

        public void setName(String qName) {
            this.myPatterns[this.myIdx] = new ClassFilter(qName);
        }

        public String getName() {
            return this.myFilters[this.myIdx];
        }

        public Project getProject() {
            return this.myProject;
        }
    }

    private static class MyClassAccessor
    extends MyAccessor
    implements RefactoringListeners.Accessor<PsiClass> {
        private MyClassAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            super(project, patterns, idx, filters);
        }

        public PsiClass getPsiElement() {
            return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.getName(), GlobalSearchScope.allScope((Project)this.getProject()));
        }

        public void setPsiElement(PsiClass psiElement) {
            this.setName(psiElement.getQualifiedName());
        }
    }

    private static class MyPackageAccessor
    extends MyAccessor
    implements RefactoringListeners.Accessor<PsiPackage> {
        private MyPackageAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            super(project, patterns, idx, filters);
        }

        @Override
        public void setName(String qualifiedName) {
            super.setName(qualifiedName + ".*");
        }

        public PsiPackage getPsiElement() {
            String name = this.getName();
            return JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(name.substring(0, name.length() - ".*".length()));
        }

        public void setPsiElement(PsiPackage psiElement) {
            this.setName(psiElement.getQualifiedName());
        }
    }
}

