/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private volatile boolean myFinished;
    private volatile long myProgressLimit;
    private final AtomicLong myProgressCount;
    private volatile long myNextChunkThreshold;
    private final String myPresentableName;
    protected final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    protected final TextRange myRestrictRange;
    @NotNull
    protected final HighlightInfoProcessor myHighlightInfoProcessor;
    protected HighlightingSession myHighlightingSession;
    private static final Key<HighlightingSession> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");

    protected ProgressableTextEditorHighlightingPass(@NotNull Project project, @Nullable Document document, @NotNull String presentableName, @Nullable PsiFile file, @Nullable Editor editor, @NotNull TextRange restrictRange, boolean runIntentionPassAfter, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        super(project, document, runIntentionPassAfter);
        this.myProgressLimit = 0L;
        this.myProgressCount = new AtomicLong();
        this.myPresentableName = presentableName;
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHighlightInfoProcessor = highlightInfoProcessor;
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && (this.myFile == null || this.myFile.isValid());
    }

    private void sessionFinished() {
        this.advanceProgress(Math.max(1L, this.myProgressLimit - this.myProgressCount.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "doCollectInformation"));
        }
        if (!(progress instanceof DaemonProgressIndicator)) {
            throw new IncorrectOperationException("Highlighting must be run under DaemonProgressIndicator, but got: " + progress);
        }
        this.myFinished = false;
        if (this.myFile != null) {
            this.myHighlightingSession = new HighlightingSessionImpl(this.myFile, this.myEditor, progress, this.getColorsScheme(), this.getId(), this.myRestrictRange);
            if (!progress.isCanceled()) {
                Disposer.register((Disposable)((Disposable)progress), (Disposable)this.myHighlightingSession);
                if (progress.isCanceled()) {
                    Disposer.dispose((Disposable)this.myHighlightingSession);
                    Disposer.dispose((Disposable)((Disposable)progress));
                }
            }
            progress.checkCanceled();
            ((DaemonProgressIndicator)progress).putUserData(HIGHLIGHTING_SESSION, this.myHighlightingSession);
        }
        try {
            this.collectInformationWithProgress(progress);
        }
        finally {
            if (this.myFile != null) {
                this.sessionFinished();
            }
        }
    }

    public static HighlightingSession getHighlightingSession(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "getHighlightingSession"));
        }
        return indicator instanceof WrappedProgressIndicator ? ProgressableTextEditorHighlightingPass.getHighlightingSession(((WrappedProgressIndicator)indicator).getOriginalProgressIndicator()) : (HighlightingSession)((UserDataHolder)indicator).getUserData(HIGHLIGHTING_SESSION);
    }

    protected abstract void collectInformationWithProgress(@NotNull ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
        this.myHighlightInfoProcessor.progressIsAdvanced(this.myHighlightingSession, 1.0);
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        long progressLimit = this.getProgressLimit();
        if (progressLimit == 0L) {
            return -1.0;
        }
        long progressCount = this.getProgressCount();
        return progressCount > progressLimit ? 1.0 : (double)progressCount / (double)progressLimit;
    }

    public long getProgressLimit() {
        return this.myProgressLimit;
    }

    public long getProgressCount() {
        return this.myProgressCount.get();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    protected String getPresentableName() {
        return this.myPresentableName;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    public void setProgressLimit(long limit) {
        this.myProgressLimit = limit;
        this.myNextChunkThreshold = Math.max(1L, limit / 100L);
    }

    public void advanceProgress(long delta) {
        long current;
        if (this.myHighlightingSession != null && (current = this.myProgressCount.addAndGet(delta)) >= this.myNextChunkThreshold) {
            double progress = this.getProgress();
            this.myNextChunkThreshold += Math.max(1L, this.myProgressLimit / 100L);
            this.myHighlightInfoProcessor.progressIsAdvanced(this.myHighlightingSession, progress);
        }
    }

    static class EmptyPass
    extends TextEditorHighlightingPass {
        public EmptyPass(Project project, @Nullable Document document) {
            super(project, document, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass$EmptyPass", "doCollectInformation"));
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            FileStatusMap statusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
            statusMap.markFileUpToDate(this.getDocument(), this.getId());
        }
    }
}

