/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final Map<PsiFile, Boolean> myFileTools = ContainerUtil.createConcurrentWeakMap();
    public InspectionProjectProfileManager myProfileManager;

    public WholeFileLocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar, InspectionProjectProfileManager profileManager) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
        this.myProfileManager = profileManager;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WholeFileLocalInspectionsPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "getComponentName"));
        }
        return "WholeFileLocalInspectionsPassFactory";
    }

    public void projectOpened() {
        ProfileChangeAdapter myProfilesListener = new ProfileChangeAdapter(){

            public void profileChanged(Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }

            public void profileActivated(Profile oldProfile, Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }
        };
        this.myProfileManager.addProfilesListener(myProfilesListener, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }
        });
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 7);
        if (textRange == null || !InspectionProjectProfileManager.getInstance(file.getProject()).isProfileLoaded() || this.myFileTools.containsKey(file) && !this.myFileTools.get(file).booleanValue()) {
            return null;
        }
        return new LocalInspectionsPass(file, editor.getDocument(), 0, file.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, new DefaultHighlightInfoProcessor()){

            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
                if (profile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "getInspectionTools"));
                }
                List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile);
                ArrayList<LocalInspectionToolWrapper> result = new ArrayList<LocalInspectionToolWrapper>(tools.size());
                for (LocalInspectionToolWrapper tool : tools) {
                    if (!tool.runForWholeFile()) continue;
                    result.add(tool);
                }
                WholeFileLocalInspectionsPassFactory.this.myFileTools.put(file, !result.isEmpty());
                ArrayList<LocalInspectionToolWrapper> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "getInspectionTools"));
                }
                return arrayList;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            @Override
            void inspectInjectedPsi(@NotNull List<PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, boolean checkDumbAwareness, @NotNull List<LocalInspectionToolWrapper> wrappers) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "inspectInjectedPsi"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "inspectInjectedPsi"));
                }
                if (iManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "inspectInjectedPsi"));
                }
                if (wrappers == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$3", "inspectInjectedPsi"));
                }
            }
        };
    }
}

