/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableUtil {
    public static boolean checkSideEffects(PsiExpression element, PsiVariable variableToIgnore, List<PsiElement> sideEffects) {
        if (sideEffects == null || element == null) {
            return false;
        }
        ArrayList<PsiElement> writes = new ArrayList<PsiElement>();
        SideEffectChecker.checkSideEffects(element, writes);
        if (variableToIgnore != null) {
            for (int i = writes.size() - 1; i >= 0; --i) {
                PsiExpression lExpression;
                PsiElement write = (PsiElement)writes.get(i);
                if (!(write instanceof PsiAssignmentExpression) || !((lExpression = ((PsiAssignmentExpression)write).getLExpression()) instanceof PsiReference) || ((PsiReference)lExpression).resolve() != variableToIgnore) continue;
                writes.remove(i);
            }
        }
        sideEffects.addAll(writes);
        return !writes.isEmpty();
    }

    static PsiElement replaceElementWithExpression(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression;
        if (element.getParent() instanceof PsiExpressionStatement) {
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        }
        return elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    static PsiElement createStatementIfNeeded(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        if (!(element.getParent() instanceof PsiExpressionStatement) && !(element.getParent() instanceof PsiDeclarationStatement)) {
            return expression;
        }
        return factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
    }

    static void deleteWholeStatement(PsiElement element, PsiElementFactory factory) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiExpressionStatement parent = (PsiExpressionStatement)element.getParent();
            if (parent.getParent() instanceof PsiCodeBlock) {
                parent.delete();
            } else {
                parent.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(null, factory, element));
            }
        } else {
            element.delete();
        }
    }

    static void deleteReferences(PsiVariable variable, List<PsiElement> references, @NotNull RemoveMode mode) throws IncorrectOperationException {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil", "deleteReferences"));
        }
        for (PsiElement expression : references) {
            RemoveUnusedVariableUtil.processUsage(expression, variable, null, mode);
        }
    }

    static void collectReferences(@NotNull PsiElement context, final PsiVariable variable, final List<PsiElement> references) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil", "collectReferences"));
        }
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    static Boolean processUsage(PsiElement element, PsiVariable variable, List<PsiElement> sideEffects, @NotNull RemoveMode deleteMode) throws IncorrectOperationException {
        if (deleteMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleteMode", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil", "processUsage"));
        }
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression.getRExpression();
                if ((rExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableUtil.checkSideEffects(rExpression, variable, sideEffects);
                if (!(element.getParent() instanceof PsiExpressionStatement) || PsiUtil.isStatement((PsiElement)rExpression)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT || deleteMode == RemoveMode.DELETE_ALL && !(element.getParent() instanceof PsiExpressionStatement)) {
                        element = RemoveUnusedVariableUtil.replaceElementWithExpression(rExpression, factory, element);
                        while (element.getParent() instanceof PsiParenthesizedExpression) {
                            element = element.getParent().replace(element);
                        }
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != RemoveMode.CANCEL) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == element) {
                    element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(";", element));
                    break;
                }
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable) {
                PsiExpression expression = variable.getInitializer();
                if (expression != null) {
                    expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
                }
                boolean sideEffectsFound = RemoveUnusedVariableUtil.checkSideEffects(expression, variable, sideEffects);
                if (expression != null && PsiUtil.isStatement((PsiElement)expression) && variable instanceof PsiLocalVariable && (!(variable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT) {
                        element = element.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(expression, factory, element));
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    public static enum RemoveMode {
        MAKE_STATEMENT,
        DELETE_ALL,
        CANCEL;

    }
}

