/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInference {
    public static final int MAX_CONTRACT_COUNT = 10;

    @NotNull
    public static List<MethodContract> inferContracts(final @NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<List<MethodContract>>(){

            @Nullable
            public CachedValueProvider.Result<List<MethodContract>> compute() {
                List result = (List)RecursionManager.doPreventingRecursion((Object)method, (boolean)true, (Computable)new Computable<List<MethodContract>>(){

                    public List<MethodContract> compute() {
                        return new ContractInferenceInterpreter(method).inferContracts();
                    }
                });
                if (result == null) {
                    result = Collections.emptyList();
                }
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        return list;
    }
}

