/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class InvertedDiffIterableWrapper
extends DiffIterableBase {
    @NotNull
    private final DiffIterable myIterable;

    public InvertedDiffIterableWrapper(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/InvertedDiffIterableWrapper", "<init>"));
        }
        this.myIterable = iterable;
    }

    @Override
    public int getLength1() {
        return this.myIterable.getLength1();
    }

    @Override
    public int getLength2() {
        return this.myIterable.getLength2();
    }

    @Override
    @NotNull
    public Iterator<DiffIterableUtil.Range> changes() {
        Iterator<DiffIterableUtil.Range> iterator = this.myIterable.unchanged();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/InvertedDiffIterableWrapper", "changes"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public Iterator<DiffIterableUtil.Range> unchanged() {
        Iterator<DiffIterableUtil.Range> iterator = this.myIterable.changes();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/InvertedDiffIterableWrapper", "unchanged"));
        }
        return iterator;
    }
}

