/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import gnu.trove.TIntFunction;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SyncScrollSupport {
    @NotNull
    private static MyScrollHelper create(@NotNull Editor master, @NotNull Editor slave, final @NotNull SyncScrollable scrollable, final @NotNull Side side) {
        if (master == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (scrollable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        MyScrollHelper myScrollHelper = new MyScrollHelper(master, slave, new TIntFunction(){

            public int execute(int value) {
                return scrollable.transfer(side, value);
            }
        });
        if (myScrollHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "create"));
        }
        return myScrollHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScrollVertically(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollVertically"));
        }
        model.disableAnimation();
        try {
            model.scrollVertically(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScrollHorizontally(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollHorizontally"));
        }
        model.disableAnimation();
        try {
            model.scrollHorizontally(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "getHeaderOffset"));
        }
        JComponent header = editor.getHeaderComponent();
        return header == null ? 0 : header.getHeight();
    }

    private static class MyScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final Editor myMaster;
        @NotNull
        private final Editor mySlave;
        @NotNull
        private final TIntFunction myConvertor;

        public MyScrollHelper(@NotNull Editor master, @NotNull Editor slave, @NotNull TIntFunction convertor) {
            if (master == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "<init>"));
            }
            this.myMaster = master;
            this.mySlave = slave;
            this.myConvertor = convertor;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            this.syncVerticalScroll(newRectangle, oldRectangle);
            this.syncHorizontalScroll(newRectangle, oldRectangle);
        }

        private void syncVerticalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "syncVerticalScroll"));
            }
            if (oldRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "syncVerticalScroll"));
            }
            if (newRectangle.y == oldRectangle.y) {
                return;
            }
            if (this.myMaster.getDocument().getTextLength() == 0) {
                return;
            }
            int masterVerticalScrollOffset = this.myMaster.getScrollingModel().getVerticalScrollOffset();
            Rectangle viewRect = this.myMaster.getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            LogicalPosition masterPos = this.myMaster.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
            int masterCenterLine = masterPos.line;
            int scrollToLine = this.myConvertor.execute(masterCenterLine);
            int correction = (masterVerticalScrollOffset + middleY) % this.myMaster.getLineHeight();
            Point point = this.mySlave.logicalPositionToXY(new LogicalPosition(scrollToLine, masterPos.column));
            int offset = point.y - middleY + correction;
            int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(this.mySlave) - SyncScrollSupport.getHeaderOffset(this.myMaster);
            SyncScrollSupport.doScrollVertically(this.mySlave.getScrollingModel(), offset + deltaHeaderOffset);
        }

        private void syncHorizontalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "syncHorizontalScroll"));
            }
            if (oldRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/diff/tools/util/SyncScrollSupport$MyScrollHelper", "syncHorizontalScroll"));
            }
            if (newRectangle.x == oldRectangle.x) {
                return;
            }
            int offset = newRectangle.x;
            SyncScrollSupport.doScrollHorizontally(this.mySlave.getScrollingModel(), offset);
        }
    }

    public static class ThreesideSyncScrollSupport {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable1;
        @NotNull
        private final SyncScrollable myScrollable2;
        @NotNull
        private final MyScrollHelper myHelper11;
        @NotNull
        private final MyScrollHelper myHelper12;
        @NotNull
        private final MyScrollHelper myHelper21;
        @NotNull
        private final MyScrollHelper myHelper22;
        public boolean myDuringSyncScroll;

        public ThreesideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable1, @NotNull SyncScrollable scrollable2) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable1", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable2", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            this.myDuringSyncScroll = false;
            assert (editors.size() == 3);
            this.myEditors = editors;
            this.myScrollable1 = scrollable1;
            this.myScrollable2 = scrollable2;
            this.myHelper11 = SyncScrollSupport.create(editors.get(0), editors.get(1), this.myScrollable1, Side.LEFT);
            this.myHelper12 = SyncScrollSupport.create(editors.get(1), editors.get(0), this.myScrollable1, Side.RIGHT);
            this.myHelper21 = SyncScrollSupport.create(editors.get(1), editors.get(2), this.myScrollable2, Side.LEFT);
            this.myHelper22 = SyncScrollSupport.create(editors.get(2), editors.get(1), this.myScrollable2, Side.RIGHT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (this.myDuringSyncScroll) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e.getEditor() == this.myEditors.get(0)) {
                    if (this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper11.visibleAreaChanged(e);
                    }
                    if (this.myScrollable1.isSyncScrollEnabled() && this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == this.myEditors.get(1)) {
                    if (this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                    }
                    if (this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == this.myEditors.get(2)) {
                    if (this.myScrollable2.isSyncScrollEnabled()) {
                        this.myHelper22.visibleAreaChanged(e);
                    }
                    if (this.myScrollable2.isSyncScrollEnabled() && this.myScrollable1.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                    }
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }
    }

    public static class TwosideSyncScrollSupport {
        @NotNull
        private final Editor myEditor1;
        @NotNull
        private final Editor myEditor2;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final MyScrollHelper myHelper1;
        @NotNull
        private final MyScrollHelper myHelper2;
        public boolean myDuringSyncScroll;

        public TwosideSyncScrollSupport(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull SyncScrollable scrollable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            if (scrollable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            this.myDuringSyncScroll = false;
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myScrollable = scrollable;
            this.myHelper1 = SyncScrollSupport.create(this.myEditor1, this.myEditor2, this.myScrollable, Side.LEFT);
            this.myHelper2 = SyncScrollSupport.create(this.myEditor2, this.myEditor1, this.myScrollable, Side.RIGHT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.myDuringSyncScroll) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e.getEditor() == this.myEditor1) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == this.myEditor2) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }
    }

    public static interface SyncScrollable {
        public boolean isSyncScrollEnabled();

        public int transfer(@NotNull Side var1, int var2);
    }
}

