/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.WaitingBackgroundableTaskExecutor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements FrameDiffTool.DiffViewer,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final WaitingBackgroundableTaskExecutor myTaskExecutor;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final AtomicBoolean myDisposed;

    public DiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        this.myTaskExecutor = new WaitingBackgroundableTaskExecutor();
        this.myAlarm = new Alarm();
        this.myDisposed = new AtomicBoolean(false);
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        this.onInit();
        this.rediff(true);
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "init"));
        }
        return toolbarComponents;
    }

    public final void dispose() {
        if (!this.myDisposed.compareAndSet(false, true)) {
            return;
        }
        Disposer.dispose((Disposable)this.myAlarm);
        this.abortRediff();
        this.onDispose();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DiffViewerBase.this.abortRediff();
                DiffViewerBase.this.onDisposeAwt();
            }
        });
    }

    public final void scheduleRediff() {
        if (this.myDisposed.get()) {
            return;
        }
        final int modificationStamp = this.myTaskExecutor.getModificationStamp();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (modificationStamp != DiffViewerBase.this.myTaskExecutor.getModificationStamp()) {
                    return;
                }
                DiffViewerBase.this.rediff();
            }
        }, 300);
    }

    public final void abortRediff() {
        this.myTaskExecutor.abort();
    }

    public final void rediff() {
        this.rediff(false);
    }

    public final void rediff(boolean trySync) {
        if (this.myDisposed.get()) {
            return;
        }
        this.onBeforeRediff();
        boolean forceEDT = ApplicationManager.getApplication().isWriteAccessAllowed();
        int waitMillis = trySync || this.tryRediffSynchronously() ? 300 : 0;
        this.myTaskExecutor.execute(new Convertor<ProgressIndicator, Runnable>(){

            public Runnable convert(ProgressIndicator indicator) {
                return DiffViewerBase.this.performRediff(indicator);
            }
        }, new Runnable(){

            @Override
            public void run() {
                DiffViewerBase.this.onSlowRediff();
            }
        }, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getRequest"));
        }
        return contentDiffRequest;
    }

    protected boolean tryRediffSynchronously() {
        return true;
    }

    @Nullable
    protected List<AnAction> createToolbarActions() {
        return null;
    }

    @Nullable
    protected List<AnAction> createPopupActions() {
        return null;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    protected void onInit() {
    }

    protected void onSlowRediff() {
    }

    protected void onBeforeRediff() {
    }

    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    protected void onDispose() {
    }

    protected void onDisposeAwt() {
    }

    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        if (DiffDataKeys.OPEN_FILE_DESCRIPTOR.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }
}

