/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsDialog;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class ExportTestResultsAction
extends DumbAwareAction {
    private static final String ID = "ExportTestResults";
    private static final Logger LOG = Logger.getInstance((String)ExportTestResultsAction.class.getName());
    private TestFrameworkRunningModel myModel;
    private String myToolWindowId;
    private RunConfiguration myRunConfiguration;

    public static ExportTestResultsAction create(String toolWindowId, RunConfiguration runtimeConfiguration) {
        ExportTestResultsAction action = new ExportTestResultsAction();
        action.copyFrom(ActionManager.getInstance().getAction(ID));
        action.myToolWindowId = toolWindowId;
        action.myRunConfiguration = runtimeConfiguration;
        return action;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
    }

    private boolean isEnabled(DataContext dataContext) {
        if (this.myModel == null) {
            return false;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
            return false;
        }
        return !this.myModel.getRoot().isInProgress();
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        LOG.assertTrue(project != null);
        final ExportTestResultsConfiguration config = ExportTestResultsConfiguration.getInstance(project);
        String name = ExecutionBundle.message((String)"export.test.results.filename", (Object[])new Object[]{PathUtil.suggestFileName((String)this.myRunConfiguration.getName())});
        String filename = name + "." + config.getExportFormat().getDefaultExtension();
        boolean showDialog = true;
        while (showDialog) {
            ExportTestResultsDialog d = new ExportTestResultsDialog(project, config, filename);
            if (!d.showAndGet()) {
                return;
            }
            filename = d.getFileName();
            showDialog = ExportTestResultsAction.getOutputFile(config, project, filename).exists() && Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"export.test.results.file.exists.message", (Object[])new Object[]{filename}), (String)ExecutionBundle.message((String)"export.test.results.file.exists.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0;
        }
        final String filename_ = filename;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, ExecutionBundle.message((String)"export.test.results.task.name", (Object[])new Object[0]), false, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void processSentToBackground() {
            }
        }){

            public void run(@NotNull ProgressIndicator indicator) {
                String outputText;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/export/ExportTestResultsAction$2", "run"));
                }
                indicator.setIndeterminate(true);
                final File outputFile = ExportTestResultsAction.getOutputFile(config, project, filename_);
                try {
                    outputText = ExportTestResultsAction.this.getOutputText(config);
                    if (outputText == null) {
                        return;
                    }
                }
                catch (IOException ex) {
                    LOG.warn((Throwable)ex);
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{ex.getMessage()}), null);
                    return;
                }
                catch (TransformerException ex) {
                    LOG.warn((Throwable)ex);
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{ex.getMessage()}), null);
                    return;
                }
                catch (SAXException ex) {
                    LOG.warn((Throwable)ex);
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{ex.getMessage()}), null);
                    return;
                }
                catch (RuntimeException ex) {
                    ExportTestResultsConfiguration c = new ExportTestResultsConfiguration();
                    c.setExportFormat(ExportTestResultsConfiguration.ExportFormat.Xml);
                    c.setOpenResults(false);
                    try {
                        String xml = ExportTestResultsAction.this.getOutputText(c);
                        LOG.error((Object)LogMessageEx.createEvent("Failed to export test results", ExceptionUtil.getThrowableText((Throwable)ex), null, null, new Attachment("dump.xml", xml)));
                    }
                    catch (Throwable ignored) {
                        LOG.error("Failed to export test results", (Throwable)ex);
                    }
                    return;
                }
                final Ref result = new Ref();
                final Ref error = new Ref();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result.set(ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                            public VirtualFile compute() {
                                outputFile.getParentFile().mkdirs();
                                VirtualFile parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputFile.getParentFile());
                                if (parent == null || !parent.isValid()) {
                                    error.set((Object)ExecutionBundle.message((String)"failed.to.create.output.file", (Object[])new Object[]{outputFile.getPath()}));
                                    return null;
                                }
                                try {
                                    VirtualFile result = parent.createChildData((Object)this, outputFile.getName());
                                    VfsUtil.saveText((VirtualFile)result, (String)outputText);
                                    return result;
                                }
                                catch (IOException e) {
                                    LOG.warn((Throwable)e);
                                    error.set((Object)e.getMessage());
                                    return null;
                                }
                            }
                        }));
                    }
                }, ModalityState.defaultModalityState());
                if (!result.isNull()) {
                    if (config.isOpenResults()) {
                        ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result.get(), project, config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                    } else {
                        HyperlinkListener listener = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                    ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result.get(), project, config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                                }
                            }
                        };
                        ExportTestResultsAction.this.showBalloon(project, MessageType.INFO, ExecutionBundle.message((String)"export.test.results.succeeded", (Object[])new Object[]{outputFile.getName()}), listener);
                    }
                } else {
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{error.get()}), null);
                }
            }
        });
    }

    @NotNull
    private static File getOutputFile(@NotNull ExportTestResultsConfiguration config, @NotNull Project project, @NotNull String filename) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/execution/testframework/export/ExportTestResultsAction", "getOutputFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/export/ExportTestResultsAction", "getOutputFile"));
        }
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/execution/testframework/export/ExportTestResultsAction", "getOutputFile"));
        }
        String outputFolderPath = config.getOutputFolder();
        File outputFolder = !StringUtil.isEmptyOrSpaces((String)outputFolderPath) ? (FileUtil.isAbsolute((String)outputFolderPath) ? new File(outputFolderPath) : new File(new File(project.getBasePath()), config.getOutputFolder())) : new File(project.getBasePath());
        File file = new File(outputFolder, filename);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/export/ExportTestResultsAction", "getOutputFile"));
        }
        return file;
    }

    private static void openEditorOrBrowser(final VirtualFile result, final Project project, final boolean editor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (editor) {
                    FileEditorManager.getInstance((Project)project).openFile(result, true);
                } else {
                    BrowserUtil.browse((VirtualFile)result);
                }
            }
        });
    }

    @Nullable
    private String getOutputText(ExportTestResultsConfiguration config) throws IOException, TransformerException, SAXException {
        TransformerHandler handler;
        ExportTestResultsConfiguration.ExportFormat exportFormat = config.getExportFormat();
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (exportFormat == ExportTestResultsConfiguration.ExportFormat.Xml) {
            handler = transformerFactory.newTransformerHandler();
            handler.getTransformer().setOutputProperty("indent", "yes");
            handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        } else {
            StreamSource xslSource;
            if (config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.BundledTemplate) {
                URL bundledXsltUrl = ((Object)((Object)this)).getClass().getResource("intellij-export.xsl");
                xslSource = new StreamSource(URLUtil.openStream((URL)bundledXsltUrl));
            } else {
                File xslFile = new File(config.getUserTemplatePath());
                if (!xslFile.isFile()) {
                    this.showBalloon(this.myRunConfiguration.getProject(), MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.custom.template.not.found", (Object[])new Object[]{xslFile.getPath()}), null);
                    return null;
                }
                xslSource = new StreamSource(xslFile);
            }
            handler = transformerFactory.newTransformerHandler(xslSource);
            handler.getTransformer().setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])new Object[]{this.myRunConfiguration.getName(), this.myRunConfiguration.getType().getDisplayName()}));
        }
        StringWriter w = new StringWriter();
        handler.setResult(new StreamResult(w));
        TestResultsXmlFormatter.execute(this.myModel.getRoot(), this.myRunConfiguration, handler);
        return w.toString();
    }

    private void showBalloon(final Project project, final MessageType type, final String text, final @Nullable HyperlinkListener listener) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                if (ToolWindowManager.getInstance((Project)project).getToolWindow(ExportTestResultsAction.this.myToolWindowId) != null) {
                    ToolWindowManager.getInstance((Project)project).notifyByBalloon(ExportTestResultsAction.this.myToolWindowId, type, text, null, listener);
                }
            }
        });
    }
}

