/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestResultsPanel
extends JPanel
implements Disposable,
DataProvider {
    private JScrollPane myLeftPane;
    private JComponent myStatisticsComponent;
    private Splitter myStatisticsSplitter;
    protected final JComponent myConsole;
    protected ToolbarPanel myToolbarPanel;
    protected final ExecutionEnvironment myEnvironment;
    private final String mySplitterProportionProperty;
    private final String myStatisticsSplitterProportionProperty;
    private final float mySplitterDefaultProportion;
    protected final AnAction[] myConsoleActions;
    protected final TestConsoleProperties myProperties;
    protected TestStatusLine myStatusLine;

    protected TestResultsPanel(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties properties, ExecutionEnvironment environment, String splitterProportionProperty, float splitterDefaultProportion) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/testframework/ui/TestResultsPanel", "<init>"));
        }
        super(new BorderLayout(0, 1));
        this.myConsole = console;
        this.myConsoleActions = consoleActions;
        this.myProperties = properties;
        this.myEnvironment = environment;
        this.mySplitterProportionProperty = splitterProportionProperty;
        this.mySplitterDefaultProportion = splitterDefaultProportion;
        this.myStatisticsSplitterProportionProperty = this.mySplitterProportionProperty + "_Statistics";
    }

    public void initUI() {
        this.myLeftPane = ScrollPaneFactory.createScrollPane();
        this.myLeftPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
        this.myStatisticsComponent = this.createStatisticsPanel();
        this.myStatusLine = this.createStatusLine();
        JComponent testTreeView = this.createTestTreeView();
        this.myToolbarPanel = this.createToolbarPanel();
        Disposer.register((Disposable)this, (Disposable)this.myToolbarPanel);
        final Splitter splitter = TestResultsPanel.createSplitter(this.mySplitterProportionProperty, this.mySplitterDefaultProportion);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                TestResultsPanel.this.remove((Component)splitter);
                splitter.dispose();
            }
        });
        this.add((Component)splitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myLeftPane, "Center");
        leftPanel.add((Component)this.myToolbarPanel, "North");
        splitter.setFirstComponent((JComponent)leftPanel);
        this.myStatusLine.setMinimumSize(new Dimension(0, this.myStatusLine.getMinimumSize().height));
        this.myStatusLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)SameHeightPanel.wrap(this.myStatusLine, this.myToolbarPanel), "North");
        this.myStatisticsSplitter = TestResultsPanel.createSplitter(this.myStatisticsSplitterProportionProperty, 0.5f);
        new AwtVisitor(this.myConsole){

            public boolean visit(Component component) {
                if (component instanceof JScrollPane) {
                    ((JScrollPane)component).putClientProperty(UIUtil.KEEP_BORDER_SIDES, 3);
                    return true;
                }
                return false;
            }
        };
        this.myStatisticsSplitter.setFirstComponent(TestResultsPanel.createOutputTab(this.myConsole, this.myConsoleActions));
        if (TestConsoleProperties.SHOW_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.showStatistics();
        }
        this.myProperties.addListener(TestConsoleProperties.SHOW_STATISTICS, new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                if (value.booleanValue()) {
                    TestResultsPanel.this.showStatistics();
                } else {
                    TestResultsPanel.this.myStatisticsSplitter.setSecondComponent(null);
                }
            }
        });
        rightPanel.add((Component)this.myStatisticsSplitter, "Center");
        splitter.setSecondComponent((JComponent)rightPanel);
        testTreeView.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.setLeftComponent(testTreeView);
    }

    private void showStatistics() {
        this.myStatisticsSplitter.setSecondComponent(this.myStatisticsComponent);
    }

    protected abstract JComponent createStatisticsPanel();

    protected ToolbarPanel createToolbarPanel() {
        return new ToolbarPanel(this.myProperties, this.myEnvironment, this);
    }

    protected TestStatusLine createStatusLine() {
        return new TestStatusLine();
    }

    protected abstract JComponent createTestTreeView();

    @Nullable
    protected TestTreeView getTreeView() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        TestTreeView view = this.getTreeView();
        if (view != null) {
            return view.getData(dataId);
        }
        return null;
    }

    private static JComponent createOutputTab(JComponent console, AnAction[] consoleActions) {
        JPanel outputTab = new JPanel(new BorderLayout());
        console.setFocusable(true);
        outputTab.add((Component)console, "Center");
        DefaultActionGroup actionGroup = new DefaultActionGroup(consoleActions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, false);
        outputTab.add((Component)toolbar.getComponent(), "West");
        return outputTab;
    }

    public void dispose() {
    }

    protected static Splitter createSplitter(final String proportionProperty, float defaultProportion) {
        float proportion;
        final Splitter splitter = new Splitter(false);
        splitter.setHonorComponentsMinimumSize(true);
        final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String value = propertiesComponent.getValue(proportionProperty);
        if (value != null) {
            try {
                proportion = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                proportion = defaultProportion;
            }
        } else {
            proportion = defaultProportion;
        }
        splitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/ui/TestResultsPanel$4", "propertyChange"));
                }
                if (event.getPropertyName().equals("proportion")) {
                    propertiesComponent.setValue(proportionProperty, String.valueOf(splitter.getProportion()));
                }
            }
        });
        splitter.setProportion(proportion);
        return splitter;
    }

    protected void setLeftComponent(JComponent component) {
        if (component != this.myLeftPane.getViewport().getView()) {
            this.myLeftPane.setViewportView(component);
        }
    }
}

