/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class ProjectPathMacroManager
extends BasePathMacroManager {
    private final Project myProject;

    public ProjectPathMacroManager(PathMacros pathMacros, Project project) {
        super(pathMacros);
        this.myProject = project;
    }

    @Override
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = super.getExpandMacroMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", ProjectPathMacroManager.getProjectDir(this.myProject));
        return result;
    }

    @Override
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = super.getReplacePathMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", ProjectPathMacroManager.getProjectDir(this.myProject), null);
        return result;
    }

    @Nullable
    private static String getProjectDir(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null ? baseDir.getPath() : null;
    }
}

