/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.local.FileWatcher");
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher$1", "compute"));
            }
            return notificationGroup;
        }
    };
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private final ManagingFS myManagingFS;
    private final File myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private volatile int myStartAttemptCount;
    private volatile boolean myIsShuttingDown;
    private final AtomicBoolean myFailureShownToTheUser;
    private final AtomicInteger mySettingRoots;
    private volatile List<String> myRecursiveWatchRoots;
    private volatile List<String> myFlatWatchRoots;
    private volatile List<String> myManualWatchRoots;
    private volatile List<Pair<String, String>> myMapping;
    private final Object myLock;
    private DirtyPaths myDirtyPaths;
    private final String[] myLastChangedPaths;
    private int myLastChangedPathIndex;
    private volatile Runnable myNotifier;

    FileWatcher(@NotNull ManagingFS managingFS) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managingFS", "com/intellij/openapi/vfs/impl/local/FileWatcher", "<init>"));
        }
        this.myStartAttemptCount = 0;
        this.myIsShuttingDown = false;
        this.myFailureShownToTheUser = new AtomicBoolean(false);
        this.mySettingRoots = new AtomicInteger(0);
        this.myRecursiveWatchRoots = ContainerUtil.emptyList();
        this.myFlatWatchRoots = ContainerUtil.emptyList();
        this.myManualWatchRoots = ContainerUtil.emptyList();
        this.myMapping = ContainerUtil.emptyList();
        this.myLock = new Object();
        this.myDirtyPaths = new DirtyPaths();
        this.myLastChangedPaths = new String[2];
        this.myNotifier = null;
        this.myManagingFS = managingFS;
        boolean disabled = Boolean.parseBoolean(System.getProperty(PROPERTY_WATCHER_DISABLED));
        this.myExecutable = FileWatcher.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            LOG.info("Native file watcher is not supported on this platform");
        } else if (!this.myExecutable.exists()) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
        } else if (!this.myExecutable.canExecute()) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable}), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vfs/impl/local/FileWatcher$2", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/local/FileWatcher$2", "hyperlinkUpdate"));
                    }
                    ShowFilePathAction.openFile(FileWatcher.this.myExecutable);
                }
            });
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess();
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DirtyPaths getDirtyPaths() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myDirtyPaths.isEmpty()) {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            // MONITOREXIT : object
            if (dirtyPaths != null) return dirtyPaths;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getDirtyPaths"));
        }
        DirtyPaths dirtyPaths = this.myDirtyPaths;
        this.myDirtyPaths = new DirtyPaths();
        this.myLastChangedPathIndex = 0;
        int i = 0;
        while (true) {
            if (i >= this.myLastChangedPaths.length) {
                DirtyPaths dirtyPaths2 = dirtyPaths;
                // MONITOREXIT : object
                if (dirtyPaths2 != null) return dirtyPaths2;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getDirtyPaths"));
            }
            this.myLastChangedPaths[i] = null;
            ++i;
        }
    }

    @NotNull
    public List<String> getManualWatchRoots() {
        List<String> list = this.myManualWatchRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "getManualWatchRoots"));
        }
        return list;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/openapi/vfs/impl/local/FileWatcher", "setWatchRoots"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/openapi/vfs/impl/local/FileWatcher", "setWatchRoots"));
        }
        this.setWatchRoots(recursive, flat, false);
    }

    public boolean isWatched(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/FileWatcher", "isWatched"));
        }
        return this.isOperational() && !this.checkWatchable(file.getPresentableUrl(), true, true).isEmpty();
    }

    @Nullable
    private static File getExecutable() {
        String execPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (execPath != null) {
            return new File(execPath);
        }
        String execName = FileWatcher.getExecutableName(false);
        if (execName == null) {
            return null;
        }
        return FileUtil.findFirstThatExist((String[])new String[]{FileUtil.join((String[])new String[]{PathManager.getBinPath(), execName}), FileUtil.join((String[])new String[]{PathManager.getHomePath(), "community", "bin", FileWatcher.getExecutableName(true)}), FileUtil.join((String[])new String[]{PathManager.getBinPath(), FileWatcher.getExecutableName(true)})});
    }

    @Nullable
    private static String getExecutableName(boolean withSubDir) {
        if (SystemInfo.isWindows) {
            return (withSubDir ? "win" + File.separator : "") + "fsnotifier.exe";
        }
        if (SystemInfo.isMac) {
            return (withSubDir ? "mac" + File.separator : "") + "fsnotifier";
        }
        if (SystemInfo.isLinux) {
            return (withSubDir ? "linux" + File.separator : "") + (SystemInfo.isAMD64 ? "fsnotifier64" : "fsnotifier");
        }
        return null;
    }

    public void notifyOnFailure(final String cause, final @Nullable NotificationListener listener) {
        LOG.warn(cause);
        if (this.myFailureShownToTheUser.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
                    Notifications.Bus.notify((Notification)((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(title, cause, NotificationType.WARNING, listener));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount++ > 10) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess();
        }
        LOG.info("Starting file watcher: " + this.myExecutable);
        ProcessBuilder processBuilder = new ProcessBuilder(this.myExecutable.getAbsolutePath());
        Process process = processBuilder.start();
        this.myProcessHandler = new MyProcessHandler(process);
        this.myProcessHandler.addProcessListener((ProcessListener)new MyProcessAdapter());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.setWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess() {
        MyProcessHandler processHandler = this.myProcessHandler;
        if (processHandler != null) {
            if (!processHandler.isProcessTerminated()) {
                boolean forceQuite = true;
                try {
                    this.writeLine(EXIT_COMMAND);
                    boolean bl = forceQuite = !processHandler.waitFor(500L);
                    if (forceQuite) {
                        LOG.warn("File watcher is still alive. Doing a force quit.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (forceQuite) {
                    processHandler.destroyProcess();
                }
            }
            this.myProcessHandler = null;
        }
    }

    private synchronized void setWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated()) {
            return;
        }
        if (ApplicationManager.getApplication().isDisposeInProgress()) {
            flat = Collections.emptyList();
            recursive = flat;
        }
        if (!restart && ((Object)this.myRecursiveWatchRoots).equals(recursive) && ((Object)this.myFlatWatchRoots).equals(flat)) {
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myMapping = ContainerUtil.emptyList();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<< " + line);
        }
        if ((processHandler = this.myProcessHandler) != null) {
            processHandler.writeLine(line);
        }
    }

    @NotNull
    private Collection<String> checkWatchable(String reportedPath, boolean isExact, boolean fastPath) {
        if (reportedPath == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "checkWatchable"));
            }
            return list;
        }
        List<String> flatWatchRoots = this.myFlatWatchRoots;
        List<String> recursiveWatchRoots = this.myRecursiveWatchRoots;
        if (flatWatchRoots.isEmpty() && recursiveWatchRoots.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "checkWatchable"));
            }
            return list;
        }
        List<Pair<String, String>> mapping = this.myMapping;
        SmartList affectedPaths = new SmartList((Object)reportedPath);
        for (Pair<String, String> map : mapping) {
            if (FileUtil.startsWith((String)reportedPath, (String)((String)map.first))) {
                affectedPaths.add((String)map.second + reportedPath.substring(((String)map.first).length()));
                continue;
            }
            if (!FileUtil.startsWith((String)reportedPath, (String)((String)map.second))) continue;
            affectedPaths.add((String)map.first + reportedPath.substring(((String)map.second).length()));
        }
        SmartList changedPaths = new SmartList();
        block1: for (String path : affectedPaths) {
            String parentPath;
            if (fastPath && !changedPaths.isEmpty()) break;
            for (String root : flatWatchRoots) {
                if (FileUtil.namesEqual((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block1;
                }
                if (!isExact || (parentPath = new File(path).getParent()) == null || !FileUtil.namesEqual((String)parentPath, (String)root)) continue;
                changedPaths.add(path);
                continue block1;
            }
            for (String root : recursiveWatchRoots) {
                if (FileUtil.startsWith((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block1;
                }
                if (isExact || (parentPath = new File(root).getParent()) == null || !FileUtil.namesEqual((String)path, (String)parentPath)) continue;
                changedPaths.add(root);
                continue block1;
            }
        }
        SmartList smartList = changedPaths;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/FileWatcher", "checkWatchable"));
        }
        return smartList;
    }

    private void notifyOnEvent() {
        Runnable notifier = this.myNotifier;
        if (notifier != null) {
            notifier.run();
        }
    }

    public static Logger getLog() {
        return LOG;
    }

    public void startup(@Nullable Runnable notifier) throws IOException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        this.myIsShuttingDown = false;
        this.myStartAttemptCount = 0;
        this.startupProcess(false);
        this.myNotifier = notifier;
    }

    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        this.myNotifier = null;
        MyProcessHandler processHandler = this.myProcessHandler;
        if (processHandler != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess();
            long t = System.currentTimeMillis();
            while (!processHandler.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 5000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    private class MyProcessAdapter
    extends ProcessAdapter {
        private WatcherOp myLastOp = null;
        private final List<String> myLines = ContainerUtil.newArrayList();

        private MyProcessAdapter() {
        }

        public void processTerminated(ProcessEvent event) {
            LOG.warn("Watcher terminated with exit code " + event.getExitCode());
            FileWatcher.this.myProcessHandler = null;
            try {
                FileWatcher.this.startupProcess(true);
            }
            catch (IOException e) {
                FileWatcher.this.shutdownProcess();
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(event.getText().trim());
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            String line = event.getText().trim();
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    String message = "Illegal watcher command: " + line;
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.debug(message);
                    } else {
                        LOG.error(message);
                    }
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    FileWatcher.this.notifyOnFailure(ApplicationBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    FileWatcher.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    this.reset();
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                FileWatcher.this.notifyOnFailure(line, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        FileWatcher.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = line.replace('\u0000', '\n');
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processRemap() {
            HashSet pairs = ContainerUtil.newHashSet();
            for (int i = 0; i < this.myLines.size() - 1; i += 2) {
                String pathA = this.preparePathForMapping(this.myLines.get(i));
                String pathB = this.preparePathForMapping(this.myLines.get(i + 1));
                pairs.add(Pair.create((Object)pathA, (Object)pathB));
            }
            FileWatcher.this.myMapping = ContainerUtil.newArrayList((Iterable)pairs);
            FileWatcher.this.notifyOnEvent();
        }

        private String preparePathForMapping(String path) {
            String localPath = FileUtil.toSystemDependentName((String)path);
            return localPath.endsWith(File.separator) ? localPath : localPath + File.separator;
        }

        private void processUnwatchable() {
            FileWatcher.this.myManualWatchRoots = Collections.unmodifiableList(ContainerUtil.newArrayList(this.myLines));
            FileWatcher.this.notifyOnEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            VirtualFile[] localRoots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                for (VirtualFile root : localRoots) {
                    ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPathsRecursive.add(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processChange(String path, WatcherOp op) {
            boolean exactPath;
            Collection paths;
            int length;
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY && path.length() == 3 && Character.isLetter(path.charAt(0))) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    Object object = FileWatcher.this.myLock;
                    synchronized (object) {
                        ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPathsRecursive.add(root.getPresentableUrl());
                    }
                }
                FileWatcher.this.notifyOnEvent();
                return;
            }
            if (op == WatcherOp.CHANGE) {
                Object root = FileWatcher.this.myLock;
                synchronized (root) {
                    for (int i = 0; i < FileWatcher.this.myLastChangedPaths.length; ++i) {
                        String lastChangedPath;
                        int last = FileWatcher.this.myLastChangedPathIndex - i - 1;
                        if (last < 0) {
                            last += FileWatcher.this.myLastChangedPaths.length;
                        }
                        if ((lastChangedPath = FileWatcher.this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                        return;
                    }
                    ((FileWatcher)FileWatcher.this).myLastChangedPaths[((FileWatcher)FileWatcher.this).myLastChangedPathIndex++] = path;
                    if (FileWatcher.this.myLastChangedPathIndex == FileWatcher.this.myLastChangedPaths.length) {
                        FileWatcher.this.myLastChangedPathIndex = 0;
                    }
                }
            }
            if ((length = path.length()) > 1 && path.charAt(length - 1) == '/') {
                path = path.substring(0, length - 1);
            }
            if ((paths = FileWatcher.this.checkWatchable(path, exactPath = op != WatcherOp.DIRTY && op != WatcherOp.RECDIRTY, false)).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not watchable, filtered: " + path);
                }
                return;
            }
            Object object = FileWatcher.this.myLock;
            synchronized (object) {
                switch (op) {
                    case STATS: 
                    case CHANGE: {
                        ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPaths.addAll(paths);
                        break;
                    }
                    case CREATE: 
                    case DELETE: {
                        for (String p : paths) {
                            ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPaths.add(p);
                            String parentPath = new File(p).getParent();
                            if (parentPath == null) continue;
                            ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPaths.add(parentPath);
                        }
                        break;
                    }
                    case DIRTY: {
                        ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyDirectories.addAll(paths);
                        break;
                    }
                    case RECDIRTY: {
                        ((FileWatcher)FileWatcher.this).myDirtyPaths.dirtyPathsRecursive.addAll(paths);
                        break;
                    }
                    default: {
                        LOG.error("Unexpected op: " + (Object)((Object)op));
                    }
                }
            }
            FileWatcher.this.notifyOnEvent();
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }

    private static class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;

        private MyProcessHandler(@NotNull Process process) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/vfs/impl/local/FileWatcher$MyProcessHandler", "<init>"));
            }
            super(process, null, null);
            this.myWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        }

        private void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        protected boolean useAdaptiveSleepingPolicyWhenReadingOutput() {
            return true;
        }
    }

    public static class DirtyPaths {
        public final List<String> dirtyPaths = ContainerUtil.newArrayList();
        public final List<String> dirtyPathsRecursive = ContainerUtil.newArrayList();
        public final List<String> dirtyDirectories = ContainerUtil.newArrayList();
        private static final DirtyPaths EMPTY = new DirtyPaths();

        private boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }
    }
}

