/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import gnu.trove.TObjectProcedure;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingStamp {
    private static final long UNINDEXED_STAMP = -1L;
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static final int VERSION = 13;
    private static final ConcurrentMap<ID<?, ?>, Long> ourIndexIdToCreationStamp = ContainerUtil.newConcurrentMap();
    static final int INVALID_FILE_ID = 0;
    private static volatile long ourLastStamp;
    private static final ConcurrentIntObjectMap<Timestamps> myTimestampsCache;
    private static final BlockingQueue<Integer> ourFinishedFiles;
    private static final Object[] ourLocks;

    private IndexingStamp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void rewriteVersion(final @NotNull File file, int version) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexingStamp", "rewriteVersion"));
        }
        long prevLastModifiedValue = file.lastModified();
        if (file.exists()) {
            FileUtil.deleteWithRenaming((File)file);
        }
        file.getParentFile().mkdirs();
        DataOutputStream os = (DataOutputStream)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

            @Nullable
            public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                try {
                    return new DataOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            }
        });
        assert (os != null);
        try {
            os.writeInt(version);
            os.writeInt(13);
        }
        finally {
            long max;
            ourIndexIdToCreationStamp.clear();
            os.close();
            ourLastStamp = max = Math.max(System.currentTimeMillis(), Math.max(prevLastModifiedValue, ourLastStamp) + 2000L);
            file.setLastModified(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean versionDiffers(@NotNull File versionFile, int currentIndexVersion) {
        boolean bl;
        if (versionFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionFile", "com/intellij/util/indexing/IndexingStamp", "versionDiffers"));
        }
        ourLastStamp = Math.max(ourLastStamp, versionFile.lastModified());
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));
        try {
            int savedIndexVersion = in.readInt();
            int commonVersion = in.readInt();
            bl = savedIndexVersion != currentIndexVersion || commonVersion != 13;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        in.close();
        return bl;
    }

    private static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/util/indexing/IndexingStamp", "getIndexCreationStamp"));
        }
        Long version = (Long)ourIndexIdToCreationStamp.get(indexName);
        if (version != null) {
            return version;
        }
        long stamp = IndexInfrastructure.getVersionFile(indexName).lastModified();
        ourIndexIdToCreationStamp.putIfAbsent(indexName, stamp);
        return stamp;
    }

    public static boolean isFileIndexedStateCurrent(VirtualFile file, ID<?, ?> indexName) {
        return file instanceof NewVirtualFile && IndexingStamp.isFileIndexedStateCurrent(((NewVirtualFile)file).getId(), indexName);
    }

    public static boolean isFileIndexedStateCurrent(int fileId, ID<?, ?> indexName) {
        try {
            return IndexingStamp.getIndexStamp(fileId, indexName) == IndexingStamp.getIndexCreationStamp(indexName);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof IOException)) {
                throw e;
            }
            return false;
        }
    }

    public static void setFileIndexedStateCurrent(int fileId, ID<?, ?> id) {
        IndexingStamp.update(fileId, id, IndexingStamp.getIndexCreationStamp(id));
    }

    public static void setFileIndexedStateUnindexed(int fileId, ID<?, ?> id) {
        IndexingStamp.update(fileId, id, -1L);
    }

    public static void setFileIndexedStateOutdated(int fileId, ID<?, ?> id) {
        IndexingStamp.update(fileId, id, -2L);
    }

    public static long getIndexStamp(@NotNull VirtualFile file, ID<?, ?> indexName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/IndexingStamp", "getIndexStamp"));
        }
        if (file instanceof NewVirtualFile && file.isValid()) {
            return IndexingStamp.getIndexStamp(((NewVirtualFile)file).getId(), indexName);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        Object object = IndexingStamp.getStripedLock(fileId);
        synchronized (object) {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                return stamp.get(indexName);
            }
            return 0L;
        }
    }

    private static Timestamps createOrGetTimeStamp(int id) {
        Timestamps timestamps;
        boolean isValid;
        boolean bl = isValid = id > 0;
        if (!isValid) {
            id = -id;
        }
        if ((timestamps = (Timestamps)myTimestampsCache.get(id)) == null) {
            DataInputStream stream = FSRecords.readAttributeWithLock(id, Timestamps.PERSISTENCE);
            try {
                timestamps = new Timestamps(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (isValid) {
                myTimestampsCache.put(id, (Object)timestamps);
            }
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/util/indexing/IndexingStamp", "update"));
        }
        if (fileId < 0 || fileId == 0) {
            return;
        }
        Object object = IndexingStamp.getStripedLock(fileId);
        synchronized (object) {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                stamp.set(indexName, indexCreationStamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        block7: {
            if (fileId != 0) {
                SmartList smartList;
                Object object = IndexingStamp.getStripedLock(fileId);
                synchronized (object) {
                    try {
                        Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                        if (stamp == null || stamp.myIndexStamps == null || stamp.myIndexStamps.isEmpty()) break block7;
                        final SmartList retained = new SmartList();
                        stamp.myIndexStamps.forEach(new TObjectProcedure<ID<?, ?>>(){

                            public boolean execute(ID<?, ?> object) {
                                retained.add(object);
                                return true;
                            }
                        });
                        smartList = retained;
                    }
                    catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                        // empty catch block
                        break block7;
                    }
                }
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexingStamp", "getNontrivialFileIndexedStates"));
                }
                return smartList;
            }
        }
        List<ID<?, ?>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexingStamp", "getNontrivialFileIndexedStates"));
        }
        return list;
    }

    public static void flushCaches() {
        IndexingStamp.flushCache((Integer)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache(@Nullable Integer finishedFile) {
        if (finishedFile != null && finishedFile == 0) {
            finishedFile = 0;
        }
        while (finishedFile == null || !ourFinishedFiles.offer(finishedFile)) {
            ArrayList files = new ArrayList(ourFinishedFiles.size());
            ourFinishedFiles.drainTo(files);
            if (!files.isEmpty()) {
                for (Integer file : files) {
                    Object object = IndexingStamp.getStripedLock(file);
                    synchronized (object) {
                        Timestamps timestamp = (Timestamps)myTimestampsCache.remove(file.intValue());
                        if (timestamp == null) {
                            continue;
                        }
                        try {
                            if (timestamp.isDirty()) {
                                com.intellij.util.io.DataOutputStream sink = FSRecords.writeAttribute(file, Timestamps.PERSISTENCE);
                                timestamp.writeToStream((DataOutputStream)sink);
                                sink.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (finishedFile != null) continue;
            break;
        }
    }

    public static void flushCache(@Nullable VirtualFile finishedVirtualFile) {
        Integer finishedFile = finishedVirtualFile instanceof NewVirtualFile ? Integer.valueOf(((NewVirtualFile)finishedVirtualFile).getId()) : null;
        IndexingStamp.flushCache(finishedFile);
    }

    private static Object getStripedLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return ourLocks[(fileId & 0xFF) % ourLocks.length];
    }

    static {
        myTimestampsCache = ContainerUtil.createConcurrentIntObjectMap();
        ourFinishedFiles = new ArrayBlockingQueue<Integer>(100);
        ourLocks = new Object[16];
        for (int i = 0; i < ourLocks.length; ++i) {
            IndexingStamp.ourLocks[i] = new Object();
        }
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                try {
                    int[] outdatedIndices = null;
                    long dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                    long diff = dominatingIndexStamp - 1040688000000L;
                    if (diff > 0L && diff < 32767L) {
                        int numberOfOutdatedIndices = (int)diff;
                        outdatedIndices = new int[numberOfOutdatedIndices];
                        while (numberOfOutdatedIndices > 0) {
                            outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT((DataInput)stream);
                        }
                        dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                    }
                    while (stream.available() > 0) {
                        ID id = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                        if (id == null) continue;
                        long stamp = IndexingStamp.getIndexCreationStamp(id);
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put((Object)id, stamp);
                    }
                    if (outdatedIndices != null) {
                        for (int outdatedIndexId : outdatedIndices) {
                            ID id = ID.findById((int)outdatedIndexId);
                            if (id == null) continue;
                            long stamp = -2L;
                            if (this.myIndexStamps == null) {
                                this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                            }
                            if (stamp > dominatingIndexStamp) continue;
                            this.myIndexStamps.put((Object)id, stamp);
                        }
                    }
                }
                finally {
                    stream.close();
                }
            }
        }

        private void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null && !this.myIndexStamps.isEmpty()) {
                final long[] data = new long[2];
                boolean dominatingStampIndex = false;
                boolean numberOfOutdatedIndex = true;
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> a, long b) {
                        if (b == -2L) {
                            data[1] = data[1] + 1L;
                            b = IndexingStamp.getIndexCreationStamp(a);
                        }
                        data[0] = Math.max(data[0], b);
                        return true;
                    }
                });
                if (data[1] > 0L) {
                    assert (data[1] < 32767L);
                    DataInputOutputUtil.writeTIME((DataOutput)stream, (long)(1040688000000L + data[1]));
                    this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                        public boolean execute(ID<?, ?> id, long timestamp) {
                            try {
                                if (timestamp == -2L) {
                                    DataInputOutputUtil.writeINT((DataOutput)stream, (int)id.getUniqueId());
                                }
                                return true;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)data[0]);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> id, long timestamp) {
                        try {
                            if (timestamp == -2L) {
                                return true;
                            }
                            DataInputOutputUtil.writeINT((DataOutput)stream, (int)id.getUniqueId());
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)1040688000000L);
            }
        }

        private long get(ID<?, ?> id) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id) : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(ID<?, ?> id, long tmst) {
            try {
                if (tmst == -1L) {
                    if (this.myIndexStamps == null) {
                        return;
                    }
                    this.myIndexStamps.remove(id);
                    return;
                }
                if (this.myIndexStamps == null) {
                    this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                }
                this.myIndexStamps.put(id, tmst);
            }
            finally {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }
}

