/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    private static final JBColor ME_BG = new JBColor(new Color(255, 255, 228), new Color(73, 71, 63));
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;

    public MyCommitsHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        VcsUser currentUser;
        if (isSelected || !this.myUiProperties.isHighlightMyCommits()) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        Map<VirtualFile, VcsUser> users = this.myDataHolder.getCurrentUser();
        Object details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (details != null && !(details instanceof LoadingDetails) && (currentUser = users.get(details.getRoot())) != null && VcsUserImpl.isSamePerson(currentUser, details.getAuthor())) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)ME_BG);
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }
}

