/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.tables;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    @NotNull
    protected final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiImpl UI2) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "UI", "com/intellij/vcs/log/ui/tables/GraphTableModel", "<init>"));
        }
        this.myLogDataHolder = dataHolder;
        this.myUi = UI2;
        this.myDataPack = dataPack;
        this.myDataHolder = dataHolder;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        int head = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getOneOfHeads();
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(head);
        if (refs.isEmpty()) {
            LOG.error("No references pointing to head " + this.myDataHolder.getHash(head) + " identified for commit at row " + rowIndex, new Attachment[]{new Attachment("details.txt", this.getErrorDetails())});
            VirtualFile virtualFile = this.myDataPack.getLogProviders().keySet().iterator().next();
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRoot"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = refs.iterator().next().getRoot();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    private String getErrorDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("LAST 100 COMMITS:\n");
        List commits = this.myDataPack.getPermanentGraph().getAllCommits();
        for (int i = 0; i < 100 && i < commits.size(); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", this.myDataHolder.getHash((Integer)commit.getId()).toShortString(), this.getParents((GraphCommit<Integer>)commit)));
        }
        sb.append("\nALL REFS:\n");
        GraphTableModel.printRefs(sb, this.myDataPack.getRefsModel().getAllRefsByRoot());
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getErrorDetails"));
        }
        return string;
    }

    @NotNull
    private String getParents(@NotNull GraphCommit<Integer> commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getParents"));
        }
        String string = StringUtil.join((Collection)commit.getParents(), (Function)new Function<Integer, String>(){

            public String fun(Integer integer) {
                return GraphTableModel.this.myDataHolder.getHash(integer).toShortString();
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getParents"));
        }
        return string;
    }

    private static void printRefs(@NotNull StringBuilder sb, @NotNull Map<VirtualFile, Set<VcsRef>> refs) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/vcs/log/ui/tables/GraphTableModel", "printRefs"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/tables/GraphTableModel", "printRefs"));
        }
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : refs.entrySet()) {
            sb.append("\n\n" + entry.getKey().getName() + ":\n");
            sb.append(StringUtil.join((Collection)entry.getValue(), (Function)new Function<VcsRef, String>(){

                public String fun(@NotNull VcsRef ref) {
                    if (ref == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/ui/tables/GraphTableModel$2", "fun"));
                    }
                    return ref.getName() + " : " + ref.getCommitHash().toShortString();
                }
            }, (String)"\n"));
        }
    }

    @NotNull
    protected GraphCommitCell getCommitColumnCell(int rowIndex, @Nullable VcsShortCommitDetails details) {
        String message = "";
        List refs = Collections.emptyList();
        if (details != null) {
            message = details.getSubject();
            refs = (List)this.myDataPack.getRefsModel().refsToCommit((Hash)details.getId());
        }
        GraphCommitCell graphCommitCell = new GraphCommitCell(message, refs);
        if (graphCommitCell == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getCommitColumnCell"));
        }
        return graphCommitCell;
    }

    @NotNull
    public Integer getCommitIdAtRow(int row) {
        Integer n = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit();
        if (n == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getCommitIdAtRow"));
        }
        return n;
    }

    @Nullable
    public Hash getHashAtRow(int row) {
        return this.myDataHolder.getHash(this.getCommitIdAtRow(row));
    }

    public int getRowOfCommit(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRowOfCommit"));
        }
        final int commitIndex = this.myDataHolder.getCommitIndex(hash);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getVisibleGraph()), (Condition)new Condition<Integer>(){

            public boolean value(Integer integer) {
                return integer == commitIndex;
            }
        });
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        if (partialHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialHash", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getRowOfCommitByPartOfHash"));
        }
        Hash hash = this.myDataHolder.getHashMap().findHashByString(partialHash);
        return hash != null ? this.getRowOfCommit(hash) : -1;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    @Nullable
    private VcsShortCommitDetails getShortDetails(int rowIndex) {
        return this.myLogDataHolder.getMiniDetailsGetter().getCommitData(rowIndex, this);
    }

    @Nullable
    public VcsFullCommitDetails getFullCommitDetails(int rowIndex) {
        return (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(rowIndex, this);
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/ui/tables/GraphTableModel", "requestToLoadMore"));
        }
        this.myMoreRequested = true;
        this.myUi.getFilterer().moreCommitsNeeded(onLoaded);
        this.myUi.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.getShortDetails(rowIndex);
        switch (columnIndex) {
            case 0: {
                VirtualFile virtualFile = this.getRoot(rowIndex);
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                }
                return virtualFile;
            }
            case 1: {
                GraphCommitCell graphCommitCell = this.getCommitColumnCell(rowIndex, data);
                if (graphCommitCell == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                }
                return graphCommitCell;
            }
            case 2: {
                if (data == null) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                    }
                    return "";
                }
                String string = data.getAuthor().getName() + (data.getAuthor().equals(data.getCommitter()) ? "" : "*");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                }
                return string;
            }
            case 3: {
                if (data == null || data.getAuthorTime() < 0L) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                    }
                    return "";
                }
                String string = DateFormatUtil.formatDateTime((long)data.getAuthorTime());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getValueAt"));
                }
                return string;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + 3);
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Nullable
    public List<Change> getSelectedChanges(@NotNull List<Integer> selectedRows) {
        if (selectedRows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/vcs/log/ui/tables/GraphTableModel", "getSelectedChanges"));
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (int row : selectedRows) {
            VcsFullCommitDetails commitData = this.getFullCommitDetails(row);
            if (commitData == null || commitData instanceof LoadingDetails) {
                return null;
            }
            changes.addAll(commitData.getChanges());
        }
        return changes;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + 3);
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/tables/GraphTableModel", "setVisiblePack"));
        }
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }
}

