/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBList;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class DebuggerFramesList
extends JBList
implements OccurenceNavigator {
    protected final Project myProject;

    public DebuggerFramesList(Project project) {
        super(new DefaultListModel());
        this.myProject = project;
    }

    protected void doInit() {
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(this.createListRenderer());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DebuggerFramesList.this.onFrameChanged(DebuggerFramesList.this.getSelectedValue());
                }
            }
        });
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.frames.not.available", (Object[])new Object[0]));
    }

    public DefaultListModel getModel() {
        return (DefaultListModel)super.getModel();
    }

    public void clear() {
        this.getModel().clear();
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public String getNextOccurenceActionName() {
        return XDebuggerBundle.message((String)"action.next.frame.text", (Object[])new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return XDebuggerBundle.message((String)"action.previous.frame.text", (Object[])new Object[0]);
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() + 1);
        return this.createInfo();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() - 1);
        return this.createInfo();
    }

    private OccurenceNavigator.OccurenceInfo createInfo() {
        return OccurenceNavigator.OccurenceInfo.position((int)this.getSelectedIndex(), (int)this.getElementCount());
    }

    public boolean hasNextOccurence() {
        return this.getSelectedIndex() < this.getElementCount() - 1;
    }

    public boolean hasPreviousOccurence() {
        return this.getSelectedIndex() > 0;
    }

    protected abstract ListCellRenderer createListRenderer();

    protected abstract void onFrameChanged(Object var1);
}

