/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CollectionSplitter<T> {
    private final int myBunchSize;

    public CollectionSplitter(int bunchSize) {
        this.myBunchSize = bunchSize;
    }

    public List<List<T>> split(Collection<T> in) {
        if (in.size() <= this.myBunchSize) {
            return Collections.singletonList(new ArrayList<T>(in));
        }
        LinkedList<List<T>> result = new LinkedList<List<T>>();
        LinkedList<T> piece = new LinkedList<T>();
        for (T path : in) {
            if (this.myBunchSize == piece.size()) {
                result.add(piece);
                piece = new LinkedList();
            }
            piece.add(path);
        }
        if (!piece.isEmpty()) {
            result.add(piece);
        }
        return result;
    }
}

