/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class BuildClasspathModuleGradleDataService
implements ProjectDataService<BuildScriptClasspathData, Module> {
    private static final Logger LOG = Logger.getInstance(BuildClasspathModuleGradleDataService.class);

    @NotNull
    public Key<BuildScriptClasspathData> getTargetDataKey() {
        Key<BuildScriptClasspathData> key = BuildScriptClasspathData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<BuildScriptClasspathData>> toImport, final @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (!project.isInitialized()) {
            return;
        }
        final GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        FactoryMap<String, Set<String>> externalProjectGradleSdkLibs = new FactoryMap<String, Set<String>>(){

            @Nullable
            protected Set<String> create(String externalProjectPath) {
                List<File> libraries;
                GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(externalProjectPath);
                if (settings == null || settings.getDistributionType() == null) {
                    return Collections.emptySet();
                }
                LinkedHashSet gradleSdkLibraries = ContainerUtil.newLinkedHashSet();
                File gradleHome = gradleInstallationManager.getGradleHome(settings.getDistributionType(), externalProjectPath, settings.getGradleHome());
                if (gradleHome != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, externalProjectPath)) != null) {
                    for (File library : libraries) {
                        gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
                    }
                }
                return gradleSdkLibraries;
            }
        };
        for (DataNode<BuildScriptClasspathData> node : toImport) {
            if (!GradleConstants.SYSTEM_ID.equals((Object)((BuildScriptClasspathData)((Object)node.getData())).getOwner())) continue;
            DataNode projectDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            String linkedExternalProjectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
            DataNode moduleDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.MODULE);
            if (moduleDataNode == null) continue;
            String externalModulePath = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedExternalProjectPath);
            if (settings == null || settings.getDistributionType() == null) {
                LOG.warn("Gradle SDK distribution type was not configured for the project at " + linkedExternalProjectPath);
            }
            LinkedHashSet buildClasspath = ContainerUtil.newLinkedHashSet();
            BuildScriptClasspathData buildScriptClasspathData = (BuildScriptClasspathData)((Object)node.getData());
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : buildScriptClasspathData.getClasspathEntries()) {
                for (String path : classpathEntry.getSourcesFile()) {
                    buildClasspath.add(FileUtil.toCanonicalPath((String)path));
                }
                for (String path : classpathEntry.getClassesFile()) {
                    buildClasspath.add(FileUtil.toCanonicalPath((String)path));
                }
            }
            ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localSettings.getProjectBuildClasspath().get(linkedExternalProjectPath);
            if (projectBuildClasspathPojo == null) {
                projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(((ModuleData)moduleDataNode.getData()).getExternalName(), (List)ContainerUtil.newArrayList(), (Map)ContainerUtil.newHashMap());
                localSettings.getProjectBuildClasspath().put(linkedExternalProjectPath, projectBuildClasspathPojo);
            }
            ArrayList projectBuildClasspath = ContainerUtil.newArrayList((Iterable)((Iterable)externalProjectGradleSdkLibs.get(linkedExternalProjectPath)));
            projectBuildClasspath.add(linkedExternalProjectPath + "/buildSrc/src/main/java");
            projectBuildClasspath.add(linkedExternalProjectPath + "/buildSrc/src/main/groovy");
            projectBuildClasspathPojo.setProjectBuildClasspath((List)projectBuildClasspath);
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, (List)ContainerUtil.newArrayList((Iterable)buildClasspath)));
        }
        GradleBuildClasspathManager.getInstance(project).reload();
    }

    public void removeData(@NotNull Collection<? extends Module> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "removeData"));
        }
    }
}

