/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.wizard.SelectExternalSystemNodeDialog;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class SelectExternalProjectDialog
extends SelectExternalSystemNodeDialog {
    private ProjectData myResult;

    public SelectExternalProjectDialog(Project project, final ProjectData current) {
        super(project, String.format("Select %s Project", GradleConstants.SYSTEM_ID.getReadableName()), ProjectNode.class, new SelectExternalSystemNodeDialog.NodeSelector(){

            @Override
            public boolean shouldSelect(SimpleNode node) {
                if (node instanceof ProjectNode) {
                    return ((ProjectNode)node).getData() == current;
                }
                return false;
            }
        });
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        AbstractAction selectNoneAction = new AbstractAction("&None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectExternalProjectDialog.this.doOKAction();
                SelectExternalProjectDialog.this.myResult = null;
            }
        };
        Action[] actionArray = new Action[]{selectNoneAction, this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/wizard/SelectExternalProjectDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        SimpleNode node = this.getSelectedNode();
        if (node instanceof NullNode) {
            node = null;
        }
        this.myResult = node instanceof ProjectNode ? (ProjectData)((ProjectNode)node).getData() : null;
        super.doOKAction();
    }

    public ProjectData getResult() {
        return this.myResult;
    }
}

