/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class MkdirOptionsDialog
extends DialogWrapper {
    private SVNURL myURL;
    private JTextArea myCommitMessage;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private JComboBox myMessagesBox;
    private JPanel myMainPanel;
    private JLabel myRecentMessagesLabel;
    private final SVNURL myOriginalURL;

    public MkdirOptionsDialog(Project project, SVNURL url) {
        super(project, true);
        this.myOriginalURL = url;
        try {
            this.$$$setupUI$$$();
            this.myURL = url.appendPath("NewFolder", true);
        }
        catch (SVNException ignore) {
            // empty catch block
        }
        this.setTitle("New Remote Folder");
        this.init();
        this.myURLLabel.setText(this.myURL.toString());
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MkdirOptionsDialog.this.updateURL();
            }
        });
        if (!project.isDefault()) {
            ArrayList messages = VcsConfiguration.getInstance((Project)project).getRecentMessages();
            Collections.reverse(messages);
            String[] model = ArrayUtil.toStringArray((Collection)messages);
            this.myMessagesBox.setModel(new DefaultComboBoxModel<String>(model));
            this.myMessagesBox.setRenderer(new MessageBoxCellRenderer());
        } else {
            this.myRecentMessagesLabel.setVisible(false);
            this.myMessagesBox.setVisible(false);
        }
        String lastMessage = VcsConfiguration.getInstance((Project)project).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        this.myMessagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MkdirOptionsDialog.this.myCommitMessage.setText(MkdirOptionsDialog.this.myMessagesBox.getSelectedItem().toString());
                MkdirOptionsDialog.this.myCommitMessage.selectAll();
            }
        });
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.mkdir.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    public SVNURL getURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SVNURL.parseURIEncoded((String)this.myURLLabel.getText());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void updateURL() {
        String newName = this.myNameField.getText();
        if (newName == null || "".equals(newName)) {
            this.myURLLabel.setText(this.myOriginalURL.toString());
            this.getOKAction().setEnabled(false);
            return;
        }
        try {
            this.myURLLabel.setText(this.myOriginalURL.appendPath(newName, false).toString());
            this.getOKAction().setEnabled(true);
        }
        catch (SVNException e) {
            this.myURLLabel.setText(this.myOriginalURL.toString());
            this.getOKAction().setEnabled(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JTextArea jTextArea;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Remote Folder URL:");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURLLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Remote Folder Name:");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setSelectionEnd(9);
        jTextField.setText("NewFolder");
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Commit Message:");
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 1, 3, 6, 6, null, null, null));
        this.myCommitMessage = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText("");
        jTextArea.setRows(10);
        jBScrollPane.setViewportView(jTextArea);
        this.myRecentMessagesLabel = jLabel = new JLabel();
        jLabel.setText("Recent Messages: ");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessagesBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(4, 1, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

