/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.ShelveLocalChangesTask;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class LocalChangesPromptTask
extends BaseMergeTask {
    private final boolean myMergeAll;
    @Nullable
    private final List<CommittedChangeList> myChangeListsToMerge;
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;

    public LocalChangesPromptTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction, boolean mergeAll, @Nullable List<CommittedChangeList> changeListsToMerge, @Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        super(mergeContext, interaction, "local changes intersection check", Where.AWT);
        this.myMergeAll = mergeAll;
        this.myChangeListsToMerge = changeListsToMerge;
        this.myCopyPoint = copyPoint;
    }

    @Nullable
    private File getLocalPath(String repositoryRelativePath) {
        String absolutePath = SVNPathUtil.append((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)repositoryRelativePath);
        SvnBranchPointsCalculator.BranchCopyData wrapped = this.myCopyPoint.getWrapped();
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)(this.myCopyPoint.isInvertedSense() ? wrapped.getSource() : wrapped.getTarget()), (String)absolutePath);
        return !StringUtil.isEmptyOrSpaces((String)sourceRelativePath) ? new File(this.myMergeContext.getWcInfo().getPath(), sourceRelativePath) : null;
    }

    public void run(ContinuationContext context) {
        Intersection intersection;
        List localChangeLists = ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).getChangeListsCopy();
        Intersection intersection2 = intersection = this.myMergeAll ? LocalChangesPromptTask.getAllChangesIntersection(localChangeLists) : this.getChangesIntersection(localChangeLists, this.myChangeListsToMerge);
        if (intersection != null && !intersection.getChangesSubset().isEmpty()) {
            this.processIntersection(context, intersection);
        }
    }

    private void processIntersection(@NotNull ContinuationContext context, @NotNull Intersection intersection) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "processIntersection"));
        }
        if (intersection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersection", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "processIntersection"));
        }
        switch (this.myInteraction.selectLocalChangesAction(this.myMergeAll)) {
            case shelve: {
                context.next(new TaskDescriptor[]{new ShelveLocalChangesTask(this.myMergeContext, this.myInteraction, intersection)});
                break;
            }
            case cancel: {
                context.cancelEverything();
                break;
            }
            case inspect: {
                Collection changes = intersection.getChangesSubset().values();
                this.myInteraction.showIntersectedLocalPaths(ContainerUtil.sorted((Collection)ChangesUtil.getPaths((Collection)changes), (Comparator)FilePathByPathComparator.getInstance()));
                context.cancelEverything();
            }
        }
    }

    @Nullable
    private Intersection getChangesIntersection(@NotNull List<LocalChangeList> localChangeLists, @Nullable List<CommittedChangeList> changeListsToMerge) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Intersection result = null;
        if (!ContainerUtil.isEmpty(changeListsToMerge)) {
            final Set<FilePath> pathsToMerge = this.collectPaths(changeListsToMerge);
            result = LocalChangesPromptTask.getChangesIntersection(localChangeLists, new Condition<Change>(){

                public boolean value(Change change) {
                    return LocalChangesPromptTask.notNullAndInSet(ChangesUtil.getBeforePath((Change)change), pathsToMerge) || LocalChangesPromptTask.notNullAndInSet(ChangesUtil.getAfterPath((Change)change), pathsToMerge);
                }
            });
        }
        return result;
    }

    @NotNull
    private Set<FilePath> collectPaths(@NotNull List<CommittedChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        HashSet<FilePath> result = new HashSet<FilePath>();
        for (CommittedChangeList list : lists) {
            SvnChangeList svnList = (SvnChangeList)list;
            for (String path : svnList.getAffectedPaths()) {
                File localPath = this.getLocalPath(path);
                if (localPath == null) continue;
                result.add((FilePath)new FilePathImpl(localPath, false));
            }
        }
        HashSet<FilePath> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        return hashSet;
    }

    @NotNull
    private static Intersection getAllChangesIntersection(@NotNull List<LocalChangeList> localChangeLists) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        Intersection intersection = LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)Conditions.alwaysTrue());
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        return intersection;
    }

    @NotNull
    private static Intersection getChangesIntersection(@NotNull List<LocalChangeList> changeLists, @NotNull Condition<Change> filter) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Intersection result = new Intersection();
        for (LocalChangeList changeList : changeLists) {
            for (Change change : changeList.getChanges()) {
                if (!filter.value((Object)change)) continue;
                result.add(changeList.getName(), changeList.getComment(), change);
            }
        }
        Intersection intersection = result;
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        return intersection;
    }

    private static boolean notNullAndInSet(@Nullable FilePath path, @NotNull Set<FilePath> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "notNullAndInSet"));
        }
        return path != null && items.contains(path);
    }
}

