/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.states.CumulativeStatistics;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.TestStatistics;

class ActualStatistics
implements TestStatistics {
    private final CumulativeStatistics myStatistics = new CumulativeStatistics();
    private String myPrefix = "";

    public ActualStatistics(Statistics statistics) {
        this.myStatistics.add(statistics);
    }

    public void setRunning() {
        this.myPrefix = "RUNNING: ";
    }

    @Override
    public String getTime() {
        return this.myPrefix + Formatters.printTime(this.myStatistics.getTime());
    }

    @Override
    public String getMemoryUsageDelta() {
        return this.showMemory(this.myStatistics.getMemoryUsage());
    }

    @Override
    public String getBeforeMemory() {
        return this.showMemory(this.myStatistics.getBeforeMemory());
    }

    @Override
    public String getAfterMemory() {
        return this.showMemory(this.myStatistics.getAfterMemory());
    }

    private String showMemory(long memoryUsage) {
        return this.myPrefix + Formatters.printFullKBMemory(memoryUsage);
    }
}

