/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory;

import com.android.annotations.concurrency.GuardedBy;
import com.android.tools.idea.memory.CircularArrayList;
import java.util.List;

class TimelineData {
    private final int myStreams;
    @GuardedBy(value="this")
    private final List<Sample> mySamples;
    @GuardedBy(value="this")
    private long myStart;
    @GuardedBy(value="this")
    private float myMaxTotal;
    @GuardedBy(value="this")
    private long myFrozen;

    TimelineData(int streams, int capacity) {
        this.myStreams = streams;
        this.mySamples = new CircularArrayList<Sample>(capacity);
        this.clear();
    }

    public synchronized long getStartTime() {
        return this.myStart;
    }

    public int getStreamCount() {
        return this.myStreams;
    }

    public synchronized float getMaxTotal() {
        return this.myMaxTotal;
    }

    public synchronized void add(long time, int type, int id, float ... values) {
        assert (values.length == this.myStreams);
        float total = 0.0f;
        for (float value : values) {
            total += value;
        }
        this.myMaxTotal = Math.max(this.myMaxTotal, total);
        this.mySamples.add(new Sample((float)(time - this.myStart) / 1000.0f, type, id, values));
    }

    public synchronized void clear() {
        this.mySamples.clear();
        this.myMaxTotal = 0.0f;
        this.myFrozen = -1L;
        this.myStart = System.currentTimeMillis();
    }

    public int size() {
        return this.mySamples.size();
    }

    public Sample get(int index) {
        return this.mySamples.get(index);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public float getEndTime() {
        long now = this.myFrozen == -1L ? System.currentTimeMillis() : this.myFrozen;
        return (float)(now - this.myStart) / 1000.0f;
    }

    public synchronized void freeze() {
        this.myFrozen = System.currentTimeMillis();
    }

    public static class Sample {
        public final float time;
        public final float[] values;
        public final int type;
        public final int id;

        public Sample(float time, int type, int id, float[] values) {
            this.time = time;
            this.values = values;
            this.type = type;
            this.id = id;
        }
    }
}

