/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.google.common.base.Predicate;
import com.jediterm.terminal.TtyConnector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtyConnectorWaitFor {
    private static final Logger LOG = Logger.getLogger(TtyConnectorWaitFor.class);
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Predicate<Integer>> myTerminationCallback = new ArrayBlockingQueue<Predicate<Integer>>(1);

    public void detach() {
        this.myWaitForThreadFuture.cancel(true);
    }

    public TtyConnectorWaitFor(final TtyConnector ttyConnector, ExecutorService executor) {
        this.myWaitForThreadFuture = executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int exitCode = 0;
                try {
                    while (true) {
                        try {
                            exitCode = ttyConnector.waitFor();
                        }
                        catch (InterruptedException e) {
                            LOG.debug((Object)e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    try {
                        if (!TtyConnectorWaitFor.this.myWaitForThreadFuture.isCancelled()) {
                            ((Predicate)TtyConnectorWaitFor.this.myTerminationCallback.take()).apply((Object)exitCode);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)e);
                    }
                }
            }
        });
    }

    public void setTerminationCallback(Predicate<Integer> r) {
        this.myTerminationCallback.offer(r);
    }
}

