/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intentions.XmlChooseColorIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions.JavaFxInjectPageLanguageIntention;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions.JavaFxWrapWithDefineIntention;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxColorReference;

public class JavaFxAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        List<String> langs;
        XmlTagValue tagValue;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator", "annotate"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!JavaFxFileTypeFactory.isFxml(containingFile)) {
            return;
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] references = element.getReferences();
            if (!JavaFxPsiUtil.isExpressionBinding(((XmlAttributeValue)element).getValue())) {
                for (PsiReference reference : references) {
                    PsiElement resolve = reference.resolve();
                    if (!(resolve instanceof PsiMember) || JavaFxPsiUtil.isVisibleInFxml((PsiMember)resolve)) continue;
                    String symbolPresentation = "'" + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)resolve) + "'";
                    Annotation annotation = holder.createErrorAnnotation(element, symbolPresentation + (resolve instanceof PsiClass ? " should be public" : " should be public or annotated with @FXML"));
                    if (resolve instanceof PsiClass) continue;
                    annotation.registerUniversalFix((IntentionAction)new AddAnnotationFix("javafx.fxml.FXML", (PsiModifierListOwner)((PsiMember)resolve), ArrayUtil.EMPTY_STRING_ARRAY), null, null);
                }
            }
            if (references.length == 1 && references[0] instanceof JavaFxColorReference) {
                JavaFxAnnotator.attachColorIcon(element, holder, StringUtil.stripQuotesAroundValue((String)element.getText()));
            }
        } else if (element instanceof XmlAttribute) {
            XmlTag referencedTag;
            XmlTag xmlTag;
            XmlAttributeValue valueElement;
            XmlAttribute attribute = (XmlAttribute)element;
            String attributeName = attribute.getName();
            if (!FxmlConstants.FX_DEFAULT_PROPERTIES.contains(attributeName) && !attribute.isNamespaceDeclaration() && JavaFxPsiUtil.isReadOnly(attributeName, attribute.getParent())) {
                holder.createErrorAnnotation(element.getNavigationElement(), "Property '" + attributeName + "' is read-only");
            }
            if ("source".equals(attributeName) && (valueElement = attribute.getValueElement()) != null && (xmlTag = attribute.getParent()) != null && (referencedTag = JavaFxDefaultPropertyElementDescriptor.getReferencedTag(xmlTag)) != null) {
                if (referencedTag.getTextOffset() > xmlTag.getTextOffset()) {
                    holder.createErrorAnnotation(valueElement.getValueTextRange(), valueElement.getValue() + " not found");
                } else if (xmlTag.getParentTag() == referencedTag.getParentTag()) {
                    Annotation annotation = holder.createErrorAnnotation(valueElement.getValueTextRange(), "Duplicate child added");
                    annotation.registerFix((IntentionAction)new JavaFxWrapWithDefineIntention(referencedTag, valueElement.getValue()));
                }
            }
        } else if (element instanceof XmlTag && "fx:script".equals(((XmlTag)element).getName()) && !StringUtil.isEmptyOrSpaces((String)(tagValue = ((XmlTag)element).getValue()).getText()) && (langs = JavaFxPsiUtil.parseInjectedLanguages((XmlFile)element.getContainingFile())).isEmpty()) {
            ASTNode openTag = element.getNode().findChildByType(XmlTokenType.XML_NAME);
            Annotation annotation = holder.createErrorAnnotation(openTag != null ? openTag.getPsi() : element, "Page language not specified.");
            annotation.registerFix((IntentionAction)new JavaFxInjectPageLanguageIntention());
        }
    }

    private static void attachColorIcon(PsiElement element, AnnotationHolder holder, String attributeValueText) {
        try {
            Color color = null;
            if (attributeValueText.startsWith("#")) {
                color = ColorUtil.fromHex((String)attributeValueText.substring(1));
            } else {
                String hexCode = ColorMap.getHexCodeForColorName((String)StringUtil.toLowerCase((String)attributeValueText));
                if (hexCode != null) {
                    color = ColorUtil.fromHex((String)hexCode);
                }
            }
            if (color != null) {
                ColorIcon icon = new ColorIcon(8, color);
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new ColorIconRenderer(icon, element));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ColorIconRenderer
    extends GutterIconRenderer {
        private final ColorIcon myIcon;
        private final PsiElement myElement;

        public ColorIconRenderer(ColorIcon icon, PsiElement element) {
            this.myIcon = icon;
            this.myElement = element;
        }

        @NotNull
        public Icon getIcon() {
            ColorIcon colorIcon = this.myIcon;
            if (colorIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator$ColorIconRenderer", "getIcon"));
            }
            return colorIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorIconRenderer renderer = (ColorIconRenderer)((Object)o);
            return !(this.myElement != null ? !this.myElement.equals(renderer.myElement) : renderer.myElement != null);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public AnAction getClickAction() {
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null) {
                        XmlChooseColorIntentionAction.chooseColor((JComponent)editor.getComponent(), (PsiElement)ColorIconRenderer.this.myElement, (String)"Color Chooser", (boolean)true);
                    }
                }
            };
        }
    }
}

