/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodOrClassSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return (e instanceof PsiClass && !(e instanceof PsiTypeParameter) || e instanceof PsiMethod) && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList result = ContainerUtil.newArrayList((Object[])new TextRange[]{e.getTextRange()});
        result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, e.getTextRange()));
        PsiElement firstChild = e.getFirstChild();
        PsiElement[] children = e.getChildren();
        if (firstChild instanceof PsiDocComment) {
            int i = 1;
            while (children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            TextRange range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            range = TextRange.create((Segment)firstChild.getTextRange());
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
        } else if (firstChild instanceof PsiComment) {
            int i = 1;
            while (children[i] instanceof PsiComment || children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            PsiElement last = children[i - 1] instanceof PsiWhiteSpace ? children[i - 2] : children[i - 1];
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            }
            range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
        }
        if (e instanceof PsiClass) {
            result.addAll(MethodOrClassSelectioner.selectWithTypeParameters((PsiClass)e));
            result.addAll(MethodOrClassSelectioner.selectBetweenBracesLines(children, editorText));
        }
        return result;
    }

    private static Collection<TextRange> selectWithTypeParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectWithTypeParameters"));
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiTypeParameterList list = psiClass.getTypeParameterList();
        if (identifier != null && list != null) {
            return Collections.singletonList(new TextRange(identifier.getTextRange().getStartOffset(), list.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectBetweenBracesLines(@NotNull PsiElement[] children, @NotNull CharSequence editorText) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectBetweenBracesLines"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectBetweenBracesLines"));
        }
        int start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children);
        if (start != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            return MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, new TextRange(start, end));
        }
        return Collections.emptyList();
    }
}

