/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ConditionCheckManager;
import com.intellij.codeInsight.ConditionChecker;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.dataFlow.MethodCheckerDetailsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionCheckDialog
extends DialogWrapper {
    private final Project myProject;
    @NotNull
    private final Splitter mainSplitter;
    @NotNull
    private final MethodsPanel myIsNullCheckMethodPanel;
    @NotNull
    private final MethodsPanel myIsNotNullCheckMethodPanel;
    @NotNull
    private final MethodsPanel myAssertIsNullMethodPanel;
    @NotNull
    private final MethodsPanel myAssertIsNotNullMethodPanel;
    @NotNull
    private final MethodsPanel myAssertTrueMethodPanel;
    @NotNull
    private final MethodsPanel myAssertFalseMethodPanel;

    public ConditionCheckDialog(Project project, String mainDialogTitle) {
        super(project, true);
        this.myProject = project;
        ConditionCheckManager manager = ConditionCheckManager.getInstance(this.myProject);
        this.mainSplitter = new Splitter(true, 0.3f);
        Splitter topThirdSplitter = new Splitter(false);
        Splitter bottomTwoThirdsSplitter = new Splitter(true);
        Splitter isNullIsNotNullCheckMethodSplitter = new Splitter(false);
        Splitter assertTrueFalseMethodSplitter = new Splitter(false);
        ArrayList<ConditionChecker> isNullCheckMethods = new ArrayList<ConditionChecker>(manager.getIsNullCheckMethods());
        ArrayList<ConditionChecker> isNotNullCheckMethods = new ArrayList<ConditionChecker>(manager.getIsNotNullCheckMethods());
        ArrayList<ConditionChecker> assertIsNullMethods = new ArrayList<ConditionChecker>(manager.getAssertIsNullMethods());
        ArrayList<ConditionChecker> assertIsNotNullMethods = new ArrayList<ConditionChecker>(manager.getAssertIsNotNullMethods());
        ArrayList<ConditionChecker> assertTrueMethods = new ArrayList<ConditionChecker>(manager.getAssertTrueMethods());
        ArrayList<ConditionChecker> assertFalseMethods = new ArrayList<ConditionChecker>(manager.getAssertFalseMethods());
        this.myAssertIsNullMethodPanel = new MethodsPanel(assertIsNullMethods, ConditionChecker.Type.ASSERT_IS_NULL_METHOD, this.myProject);
        this.myAssertIsNotNullMethodPanel = new MethodsPanel(assertIsNotNullMethods, ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD, this.myProject);
        this.myIsNullCheckMethodPanel = new MethodsPanel(isNullCheckMethods, ConditionChecker.Type.IS_NULL_METHOD, this.myProject);
        this.myIsNotNullCheckMethodPanel = new MethodsPanel(isNotNullCheckMethods, ConditionChecker.Type.IS_NOT_NULL_METHOD, this.myProject);
        this.myAssertTrueMethodPanel = new MethodsPanel(assertTrueMethods, ConditionChecker.Type.ASSERT_TRUE_METHOD, this.myProject);
        this.myAssertFalseMethodPanel = new MethodsPanel(assertFalseMethods, ConditionChecker.Type.ASSERT_FALSE_METHOD, this.myProject);
        isNullIsNotNullCheckMethodSplitter.setFirstComponent((JComponent)this.myIsNullCheckMethodPanel.getComponent());
        isNullIsNotNullCheckMethodSplitter.setSecondComponent((JComponent)this.myIsNotNullCheckMethodPanel.getComponent());
        assertTrueFalseMethodSplitter.setFirstComponent((JComponent)this.myAssertTrueMethodPanel.getComponent());
        assertTrueFalseMethodSplitter.setSecondComponent((JComponent)this.myAssertFalseMethodPanel.getComponent());
        topThirdSplitter.setFirstComponent((JComponent)this.myAssertIsNullMethodPanel.getComponent());
        topThirdSplitter.setSecondComponent((JComponent)this.myAssertIsNotNullMethodPanel.getComponent());
        bottomTwoThirdsSplitter.setFirstComponent((JComponent)isNullIsNotNullCheckMethodSplitter);
        bottomTwoThirdsSplitter.setSecondComponent((JComponent)assertTrueFalseMethodSplitter);
        this.mainSplitter.setFirstComponent((JComponent)topThirdSplitter);
        this.mainSplitter.setSecondComponent((JComponent)bottomTwoThirdsSplitter);
        topThirdSplitter.setPreferredSize((Dimension)JBUI.size((int)600, (int)150));
        bottomTwoThirdsSplitter.setPreferredSize((Dimension)JBUI.size((int)600, (int)300));
        this.myAssertIsNullMethodPanel.setOtherMethodsPanels(this.myAssertIsNotNullMethodPanel, this.myIsNullCheckMethodPanel, this.myIsNotNullCheckMethodPanel, this.myAssertTrueMethodPanel, this.myAssertFalseMethodPanel);
        this.myAssertIsNotNullMethodPanel.setOtherMethodsPanels(this.myAssertIsNullMethodPanel, this.myIsNullCheckMethodPanel, this.myIsNotNullCheckMethodPanel, this.myAssertTrueMethodPanel, this.myAssertFalseMethodPanel);
        this.myIsNullCheckMethodPanel.setOtherMethodsPanels(this.myAssertIsNullMethodPanel, this.myAssertIsNotNullMethodPanel, this.myIsNotNullCheckMethodPanel, this.myAssertTrueMethodPanel, this.myAssertFalseMethodPanel);
        this.myIsNotNullCheckMethodPanel.setOtherMethodsPanels(this.myAssertIsNullMethodPanel, this.myAssertIsNotNullMethodPanel, this.myIsNullCheckMethodPanel, this.myAssertTrueMethodPanel, this.myAssertFalseMethodPanel);
        this.myAssertTrueMethodPanel.setOtherMethodsPanels(this.myAssertIsNullMethodPanel, this.myAssertIsNotNullMethodPanel, this.myIsNotNullCheckMethodPanel, this.myIsNullCheckMethodPanel, this.myAssertFalseMethodPanel);
        this.myAssertFalseMethodPanel.setOtherMethodsPanels(this.myAssertIsNullMethodPanel, this.myAssertIsNotNullMethodPanel, this.myIsNotNullCheckMethodPanel, this.myIsNullCheckMethodPanel, this.myAssertTrueMethodPanel);
        this.init();
        this.setTitle(mainDialogTitle);
    }

    protected JComponent createCenterPanel() {
        return this.mainSplitter;
    }

    protected void doOKAction() {
        ConditionCheckManager manager = ConditionCheckManager.getInstance(this.myProject);
        manager.setIsNotNullCheckMethods(this.myIsNotNullCheckMethodPanel.getConditionChecker());
        manager.setIsNullCheckMethods(this.myIsNullCheckMethodPanel.getConditionChecker());
        manager.setAssertIsNotNullMethods(this.myAssertIsNotNullMethodPanel.getConditionChecker());
        manager.setAssertIsNullMethods(this.myAssertIsNullMethodPanel.getConditionChecker());
        manager.setAssertTrueMethods(this.myAssertTrueMethodPanel.getConditionChecker());
        manager.setAssertFalseMethods(this.myAssertFalseMethodPanel.getConditionChecker());
        super.doOKAction();
    }

    class MethodsPanel {
        @NotNull
        private final JBList myList;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final Project myProject;
        private Set<MethodsPanel> otherPanels;

        public MethodsPanel(List<ConditionChecker> checkers, final @NotNull ConditionChecker.Type type, Project myProject) {
            if (myProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/codeInspection/dataFlow/ConditionCheckDialog$MethodsPanel", "<init>"));
            }
            this.myProject = myProject;
            this.myList = new JBList((ListModel)new CollectionListModel(checkers));
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.initTitle(type), (boolean)false, (Insets)new Insets(10, 0, 0, 0)));
            this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)150));
            this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    String s = value.toString();
                    if (s.contains("*")) {
                        int indexOfAsterix1 = s.indexOf("*");
                        int indexOfAsterix2 = s.lastIndexOf("*");
                        if (indexOfAsterix1 >= 0 && indexOfAsterix1 < s.length() && indexOfAsterix2 >= 0 && indexOfAsterix2 < s.length() && indexOfAsterix1 < indexOfAsterix2) {
                            this.append(s.substring(0, indexOfAsterix1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(s.substring(indexOfAsterix1 + 1, indexOfAsterix2), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                            this.append(s.substring(indexOfAsterix2 + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        } else {
                            this.append(s, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                    }
                }
            });
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.myList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    MethodsPanel.this.chooseMethod(null, type, MethodsPanel.this.myList.getModel().getSize());
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    CollectionListModel model = MethodsPanel.this.getCollectionListModel();
                    if (MethodsPanel.this.myList.getSelectedIndex() >= 0 && MethodsPanel.this.myList.getSelectedIndex() < model.getSize()) {
                        model.remove(MethodsPanel.this.myList.getSelectedIndex());
                    }
                }
            });
            this.myList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = MethodsPanel.this.myList.locationToIndex(e.getPoint());
                        CollectionListModel model = MethodsPanel.this.getCollectionListModel();
                        if (index >= 0 && model.getSize() > index) {
                            MethodsPanel.this.chooseMethod((ConditionChecker)model.getElementAt(index), type, index);
                        }
                    }
                }
            });
            JPanel panel = toolbarDecorator.createPanel();
            this.myPanel.add(panel);
            this.myList.setSelectionMode(0);
        }

        private String initTitle(@NotNull ConditionChecker.Type type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/ConditionCheckDialog$MethodsPanel", "initTitle"));
            }
            if (type.equals((Object)ConditionChecker.Type.IS_NULL_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.isNull.method.panel.title", (Object[])new Object[0]);
            }
            if (type.equals((Object)ConditionChecker.Type.IS_NOT_NULL_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.isNotNull.method.panel.title", (Object[])new Object[0]);
            }
            if (type.equals((Object)ConditionChecker.Type.ASSERT_IS_NULL_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.assert.isNull.method.panel.title", (Object[])new Object[0]);
            }
            if (type.equals((Object)ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.assert.isNotNull.method.panel.title", (Object[])new Object[0]);
            }
            if (type.equals((Object)ConditionChecker.Type.ASSERT_TRUE_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.assert.true.method.panel.title", (Object[])new Object[0]);
            }
            if (type.equals((Object)ConditionChecker.Type.ASSERT_FALSE_METHOD)) {
                return InspectionsBundle.message((String)"configure.checker.option.assert.false.method.panel.title", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException("MethodCheckerDetailsDialog does not support type " + (Object)((Object)type));
        }

        private void chooseMethod(@Nullable ConditionChecker checker, ConditionChecker.Type type, int index) {
            MethodCheckerDetailsDialog pickMethodPanel = new MethodCheckerDetailsDialog(checker, type, this.myProject, this.myPanel, this.getConditionCheckers(), this.getOtherCheckers());
            pickMethodPanel.show();
            ConditionChecker chk = pickMethodPanel.getConditionChecker();
            if (chk != null) {
                CollectionListModel<ConditionChecker> model = this.getCollectionListModel();
                if (model.getSize() <= index) {
                    model.add((Object)chk);
                } else {
                    model.setElementAt((Object)chk, index);
                }
            }
        }

        private CollectionListModel<ConditionChecker> getCollectionListModel() {
            return (CollectionListModel)this.myList.getModel();
        }

        @NotNull
        public JPanel getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ConditionCheckDialog$MethodsPanel", "getComponent"));
            }
            return jPanel;
        }

        public List<ConditionChecker> getConditionChecker() {
            CollectionListModel<ConditionChecker> model = this.getCollectionListModel();
            return new ArrayList<ConditionChecker>(model.getItems());
        }

        public Set<ConditionChecker> getConditionCheckers() {
            HashSet<ConditionChecker> set = new HashSet<ConditionChecker>();
            set.addAll(this.getConditionChecker());
            return set;
        }

        public void setOtherMethodsPanels(MethodsPanel p1, MethodsPanel p2, MethodsPanel p3, MethodsPanel p4, MethodsPanel p5) {
            this.otherPanels = new HashSet<MethodsPanel>();
            this.otherPanels.add(p1);
            this.otherPanels.add(p2);
            this.otherPanels.add(p3);
            this.otherPanels.add(p4);
            this.otherPanels.add(p5);
        }

        public Set<ConditionChecker> getOtherCheckers() {
            HashSet<ConditionChecker> otherCheckers = new HashSet<ConditionChecker>();
            for (MethodsPanel otherPanel : this.otherPanels) {
                otherCheckers.addAll(otherPanel.getConditionCheckers());
            }
            return otherCheckers;
        }
    }
}

