/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    private final Map<DfaMemoryStateImpl, LinkedHashSet<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(List<DfaMemoryStateImpl> states) {
        MultiMap statesByFact = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue((Object)fact, (Object)state);
            }
        }
        for (final Fact fact : statesByFact.keySet()) {
            Collection statesWithNegations;
            if (statesByFact.get((Object)fact).size() == states.size() || fact.myPositive || (statesWithNegations = statesByFact.get((Object)fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, statesByFact.get((Object)fact));
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, statesWithNegations);
            Replacements replacements = new Replacements(states);
            for (Set key : statesByUnrelatedFacts1.keySet()) {
                Collection group1 = statesByUnrelatedFacts1.get((Object)key);
                Collection group2 = statesByUnrelatedFacts2.get((Object)key);
                if (group1.isEmpty() || group2.isEmpty()) continue;
                final ArrayList group = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{group1, group2}));
                final Set<DfaVariableValue> unknowns = StateMerger.getAllUnknownVariables(group);
                replacements.stripAndMerge(group, new Function<DfaMemoryStateImpl, DfaMemoryStateImpl>(){

                    public DfaMemoryStateImpl fun(DfaMemoryStateImpl original) {
                        DfaMemoryStateImpl copy = StateMerger.withUnknownVariables(original, unknowns);
                        fact.removeFromState(copy);
                        if (fact.myType == FactType.equality) {
                            StateMerger.this.restoreOtherInequalities(fact, group, copy);
                        }
                        return copy;
                    }
                });
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Set<Fact>, DfaMemoryStateImpl> mapByUnrelatedFacts(Fact fact, Collection<DfaMemoryStateImpl> states1) {
        MultiMap statesByUnrelatedFacts1 = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states1) {
            statesByUnrelatedFacts1.putValue(this.getUnrelatedFacts(fact, state), (Object)state);
        }
        MultiMap multiMap = statesByUnrelatedFacts1;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "mapByUnrelatedFacts"));
        }
        return multiMap;
    }

    private LinkedHashSet<Fact> getUnrelatedFacts(final Fact fact, DfaMemoryStateImpl state) {
        return new LinkedHashSet<Fact>(ContainerUtil.filter(this.getFacts(state), (Condition)new Condition<Fact>(){

            public boolean value(Fact another) {
                return !fact.invalidatesFact(another);
            }
        }));
    }

    private void restoreOtherInequalities(Fact removedFact, Collection<DfaMemoryStateImpl> mergedGroup, DfaMemoryStateImpl state) {
        Set<DfaConstValue> inequalitiesToRestore = null;
        for (DfaMemoryStateImpl member : mergedGroup) {
            LinkedHashSet<Fact> memberFacts = this.getFacts(member);
            if (!memberFacts.contains(removedFact)) continue;
            Set<DfaConstValue> otherInequalities = StateMerger.getOtherInequalities(removedFact, memberFacts, member);
            if (inequalitiesToRestore == null) {
                inequalitiesToRestore = otherInequalities;
                continue;
            }
            inequalitiesToRestore.retainAll(otherInequalities);
        }
        if (inequalitiesToRestore != null) {
            DfaRelationValue.Factory relationFactory = state.getFactory().getRelationFactory();
            for (DfaConstValue toRestore : inequalitiesToRestore) {
                state.applyCondition(relationFactory.createRelation(removedFact.myVar, toRestore, JavaTokenType.EQEQ, true));
            }
        }
    }

    private static Set<DfaConstValue> getOtherInequalities(Fact removedFact, LinkedHashSet<Fact> memberFacts, DfaMemoryStateImpl state) {
        LinkedHashSet otherInequalities = ContainerUtil.newLinkedHashSet();
        HashSet eqValues = ContainerUtil.newHashSet(state.getEquivalentValues((DfaValue)removedFact.myArg));
        for (Fact candidate : memberFacts) {
            if (candidate.myType != FactType.equality || candidate.myPositive || candidate.myVar != removedFact.myVar || eqValues.contains((DfaValue)candidate.myArg) || !(candidate.myArg instanceof DfaConstValue)) continue;
            otherInequalities.add((DfaConstValue)candidate.myArg);
        }
        return otherInequalities;
    }

    private static Set<DfaVariableValue> getAllUnknownVariables(Collection<DfaMemoryStateImpl> complementary) {
        LinkedHashSet toFlush = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryStateImpl removedState : complementary) {
            toFlush.addAll(removedState.getUnknownVariables());
        }
        return toFlush;
    }

    private static DfaMemoryStateImpl withUnknownVariables(DfaMemoryStateImpl original, Set<DfaVariableValue> toFlush) {
        DfaMemoryStateImpl copy = original.createCopy();
        for (DfaVariableValue value : toFlush) {
            copy.doFlush(value, true);
        }
        return copy;
    }

    @Nullable
    public List<DfaMemoryStateImpl> mergeByUnknowns(List<DfaMemoryStateImpl> states) {
        MultiMap byHash = new MultiMap();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue((Object)state.getPartialHashCode(false, true), (Object)state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get((Object)key);
            if (similarStates.size() < 2) continue;
            for (final DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                List complementary = ContainerUtil.filter((Collection)similarStates, (Condition)new Condition<DfaMemoryStateImpl>(){

                    public boolean value(DfaMemoryStateImpl state2) {
                        return state1.equalsByRelations(state2) && state1.equalsByVariableStates(state2);
                    }
                });
                if (!StateMerger.mergeUnknowns(replacements, complementary)) continue;
                continue block1;
            }
        }
        return replacements.getMergeResult();
    }

    @Nullable
    public List<DfaMemoryStateImpl> mergeByNullability(List<DfaMemoryStateImpl> states) {
        MultiMap byHash = new MultiMap();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue((Object)state.getPartialHashCode(false, false), (Object)state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get((Object)key);
            if (similarStates.size() < 2) continue;
            for (final DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                for (final DfaVariableValue var : state1.getChangedVariables()) {
                    List complementary;
                    if (state1.getVariableState(var).getNullability() != Nullness.NULLABLE || !StateMerger.mergeUnknowns(replacements, complementary = ContainerUtil.filter((Collection)similarStates, (Condition)new Condition<DfaMemoryStateImpl>(){

                        public boolean value(DfaMemoryStateImpl state2) {
                            return state1.equalsByRelations(state2) && StateMerger.this.areEquivalentModuloVar(state1, state2, var) && StateMerger.areVarStatesEqualModuloNullability(state1, state2, var);
                        }
                    }))) continue;
                    continue block1;
                }
            }
        }
        return replacements.getMergeResult();
    }

    private static boolean mergeUnknowns(Replacements replacements, List<DfaMemoryStateImpl> complementary) {
        if (complementary.size() < 2) {
            return false;
        }
        final Set<DfaVariableValue> toFlush = StateMerger.getAllUnknownVariables(complementary);
        if (toFlush.isEmpty()) {
            return false;
        }
        return replacements.stripAndMerge(complementary, new Function<DfaMemoryStateImpl, DfaMemoryStateImpl>(){

            public DfaMemoryStateImpl fun(DfaMemoryStateImpl original) {
                return StateMerger.withUnknownVariables(original, toFlush);
            }
        });
    }

    private boolean areEquivalentModuloVar(DfaMemoryStateImpl state1, DfaMemoryStateImpl state2, DfaVariableValue var) {
        DfaMemoryStateImpl copy1 = this.copyWithoutVar(state1, var);
        DfaMemoryStateImpl copy2 = this.copyWithoutVar(state2, var);
        return copy2.equalsByRelations(copy1) && copy2.equalsByVariableStates(copy1);
    }

    private DfaMemoryStateImpl copyWithoutVar(DfaMemoryStateImpl state, DfaVariableValue var) {
        DfaMemoryStateImpl copy;
        IdentityHashMap map = this.myCopyCache.get(state);
        if (map == null) {
            map = ContainerUtil.newIdentityHashMap();
            this.myCopyCache.put(state, map);
        }
        if ((copy = map.get(var)) == null) {
            copy = state.createCopy();
            copy.flushVariable(var);
            map.put(var, copy);
        }
        return copy;
    }

    private static boolean areVarStatesEqualModuloNullability(DfaMemoryStateImpl state1, DfaMemoryStateImpl state2, DfaVariableValue var) {
        return state1.getVariableState(var).withNullability(Nullness.UNKNOWN).equals(state2.getVariableState(var).withNullability(Nullness.UNKNOWN));
    }

    private LinkedHashSet<Fact> getFacts(DfaMemoryStateImpl state) {
        LinkedHashSet result = this.myFacts.get(state);
        if (result != null) {
            return result;
        }
        result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            DfaValue constant = eqClass.findConstant(true);
            List<DfaVariableValue> vars = eqClass.getVariables(false);
            for (DfaVariableValue var : vars) {
                if (constant != null) {
                    result.add(Fact.createEqualityFact(var, constant, true));
                }
                for (DfaVariableValue eqVar : vars) {
                    if (var == eqVar) continue;
                    result.add(Fact.createEqualityFact(var, eqVar, true));
                }
            }
        }
        for (UnorderedPair unorderedPair : state.getDistinctClassPairs()) {
            List<DfaVariableValue> vars1 = ((EqClass)unorderedPair.first).getVariables(false);
            List<DfaVariableValue> vars2 = ((EqClass)unorderedPair.second).getVariables(false);
            LinkedHashSet<DfaVariableValue> firstSet = new LinkedHashSet<DfaVariableValue>(vars1);
            ContainerUtil.addIfNotNull(firstSet, (Object)((EqClass)unorderedPair.first).findConstant(true));
            LinkedHashSet<DfaVariableValue> secondSet = new LinkedHashSet<DfaVariableValue>(vars2);
            ContainerUtil.addIfNotNull(secondSet, (Object)((EqClass)unorderedPair.second).findConstant(true));
            for (DfaVariableValue var : vars1) {
                for (DfaValue dfaValue : secondSet) {
                    result.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
            for (DfaVariableValue var : vars2) {
                for (DfaValue dfaValue : firstSet) {
                    result.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
        }
        Map<DfaVariableValue, DfaVariableState> states = state.getVariableStates();
        for (DfaVariableValue var : states.keySet()) {
            DfaVariableState variableState = states.get(var);
            for (DfaPsiType type : variableState.getInstanceofValues()) {
                result.add(new Fact(FactType.instanceOf, var, true, type));
            }
            for (DfaPsiType type : variableState.getNotInstanceofValues()) {
                result.add(new Fact(FactType.instanceOf, var, false, type));
            }
        }
        this.myFacts.put(state, result);
        return result;
    }

    private static class Replacements {
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates = ContainerUtil.newIdentityTroveSet();
        private final List<DfaMemoryStateImpl> myMerged = ContainerUtil.newArrayList();

        Replacements(List<DfaMemoryStateImpl> allStates) {
            this.myAllStates = allStates;
        }

        boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList result = ContainerUtil.newArrayList(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result.add(state);
                }
                return result;
            }
            return null;
        }

        boolean stripAndMerge(Collection<DfaMemoryStateImpl> group, Function<DfaMemoryStateImpl, DfaMemoryStateImpl> stripper) {
            if (group.size() <= 1) {
                return false;
            }
            boolean hasMerges = false;
            MultiMap strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                strippedToOriginals.putValue(stripper.fun((Object)original), (Object)original);
            }
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = (Collection)entry.getValue();
                if (merged.size() <= 1) continue;
                this.myRemovedStates.addAll(merged);
                this.myMerged.add((DfaMemoryStateImpl)entry.getKey());
                hasMerges = true;
            }
            return hasMerges;
        }
    }

    private static class Fact {
        final FactType myType;
        final DfaVariableValue myVar;
        final boolean myPositive;
        final Object myArg;

        private Fact(FactType type, DfaVariableValue var, boolean positive, Object arg) {
            this.myType = type;
            this.myVar = var;
            this.myPositive = positive;
            this.myArg = arg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Fact)) {
                return false;
            }
            Fact fact = (Fact)o;
            if (this.myPositive != fact.myPositive) {
                return false;
            }
            if (!this.myArg.equals(fact.myArg)) {
                return false;
            }
            if (this.myType != fact.myType) {
                return false;
            }
            return this.myVar.equals(fact.myVar);
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myVar.hashCode();
            result = 31 * result + (this.myPositive ? 1 : 0);
            result = 31 * result + this.myArg.hashCode();
            return result;
        }

        public String toString() {
            return this.myVar + " " + (this.myPositive ? "" : "!") + (Object)((Object)this.myType) + " " + this.myArg;
        }

        static Fact createEqualityFact(DfaVariableValue var, DfaValue val, boolean equal) {
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                return new Fact(FactType.equality, (DfaVariableValue)val, equal, var);
            }
            return new Fact(FactType.equality, var, equal, val);
        }

        Fact getPositiveCounterpart() {
            return new Fact(this.myType, this.myVar, true, this.myArg);
        }

        boolean invalidatesFact(Fact another) {
            if (another.myType != this.myType) {
                return false;
            }
            if (this.myType == FactType.equality) {
                return Fact.aboutSame(this.myVar, another.myVar) || Fact.aboutSame(this.myVar, another.myArg);
            }
            return Fact.aboutSame(this.myVar, another.myVar) && Fact.aboutSame(this.myArg, another.myArg);
        }

        static boolean aboutSame(Object v1, Object v2) {
            return Fact.normalize(v1) == Fact.normalize(v2);
        }

        static Object normalize(Object value) {
            if (value instanceof DfaVariableValue && ((DfaVariableValue)value).isNegated()) {
                return ((DfaVariableValue)value).createNegated();
            }
            return value;
        }

        void removeFromState(DfaMemoryStateImpl state) {
            DfaVariableState varState = state.getVariableState(this.myVar);
            if (this.myType == FactType.equality) {
                state.flushVariable(this.myVar);
                state.setVariableState(this.myVar, varState);
            } else {
                state.setVariableState(this.myVar, varState.withoutType((DfaPsiType)this.myArg));
            }
        }
    }

    private static enum FactType {
        equality,
        instanceOf;

    }
}

