/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionRVContentProviderImpl
extends InspectionRVContentProvider {
    public InspectionRVContentProviderImpl(Project project) {
        super(project);
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "checkReportedProblems"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "checkReportedProblems"));
        }
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        presentation.updateContent();
        SearchScope searchScope = context.getCurrentScope().toSearchScope();
        if (searchScope instanceof LocalSearchScope) {
            Map<String, Set<RefEntity>> contents = presentation.getContent();
            Map<RefEntity, CommonProblemDescriptor[]> problemElements = presentation.getProblemElements();
            for (Set<RefEntity> entities : contents.values()) {
                Iterator<RefEntity> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    TextRange range;
                    PsiElement element;
                    RefEntity entity = iterator.next();
                    if (entity instanceof RefElement && (element = ((RefElement)entity).getElement()) != null && (range = element.getTextRange()) != null && ((LocalSearchScope)searchScope).containsRange(element.getContainingFile(), range)) continue;
                    problemElements.remove(entity);
                    iterator.remove();
                }
            }
        }
        return presentation.hasReportedProblems();
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "getQuickFixes"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "getQuickFixes"));
        }
        RefEntity[] refEntities = tree.getSelectedElements();
        InspectionToolPresentation presentation = tree.getContext().getPresentation(toolWrapper);
        return refEntities.length == 0 ? null : presentation.getQuickFixes(refEntities);
    }

    @Override
    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, @NotNull Map<String, Set<RefEntity>> contents, final @NotNull Map<RefEntity, CommonProblemDescriptor[]> problems, DefaultTreeModel model) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        Object computeContainer = new Function<RefEntity, InspectionRVContentProvider.UserObjectContainer<RefEntity>>(){

            public InspectionRVContentProvider.UserObjectContainer<RefEntity> fun(RefEntity refElement) {
                return new RefElementContainer(refElement, (CommonProblemDescriptor[])problems.get(refElement));
            }
        };
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        Set<RefModule> moduleProblems = presentation.getModuleProblems();
        if (!moduleProblems.isEmpty()) {
            HashSet entities = contents.get("");
            if (entities == null) {
                entities = new HashSet();
                contents.put("", entities);
            }
            entities.addAll(moduleProblems);
        }
        List<InspectionTreeNode> list = this.buildTree(context, contents, false, toolWrapper, computeContainer, showStructure);
        for (InspectionTreeNode node : list) {
            InspectionRVContentProviderImpl.merge(model, node, toolNode, true);
        }
        if (presentation.isOldProblemsIncluded()) {
            final Map<RefEntity, CommonProblemDescriptor[]> oldProblems = presentation.getOldProblemElements();
            computeContainer = new Function<RefEntity, InspectionRVContentProvider.UserObjectContainer<RefEntity>>(){

                public InspectionRVContentProvider.UserObjectContainer<RefEntity> fun(RefEntity refElement) {
                    return new RefElementContainer(refElement, oldProblems != null ? (CommonProblemDescriptor[])oldProblems.get(refElement) : null);
                }
            };
            list = this.buildTree(context, presentation.getOldContent(), true, toolWrapper, computeContainer, showStructure);
            for (InspectionTreeNode node : list) {
                InspectionRVContentProviderImpl.merge(model, node, toolNode, true);
            }
        }
        InspectionRVContentProviderImpl.merge(model, toolNode, parentNode, false);
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.UserObjectContainer container, @NotNull InspectionPackageNode pNode, boolean canPackageRepeat) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (pNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        RefElementContainer refElementDescriptor = (RefElementContainer)container;
        RefEntity refElement = refElementDescriptor.getUserObject();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        if (context.getUIOptions().SHOW_ONLY_DIFF && presentation.getElementStatus(refElement) == FileStatus.NOT_CHANGED) {
            return;
        }
        CommonProblemDescriptor[] problems = refElementDescriptor.getProblemDescriptors();
        if (problems != null) {
            RefElementNode elemNode = InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
            for (CommonProblemDescriptor problem : problems) {
                assert (problem != null);
                if (context.getUIOptions().SHOW_ONLY_DIFF && presentation.getProblemStatus(problem) == FileStatus.NOT_CHANGED) continue;
                elemNode.add(new ProblemDescriptionNode(refElement, problem, toolWrapper, presentation));
                if (problems.length != 1) continue;
                elemNode.setProblem(problems[0]);
            }
        } else {
            HashSet currentEntities;
            Set<RefEntity> currentElements;
            if (canPackageRepeat && (currentElements = presentation.getContent().get(pNode.getPackageName())) != null && RefUtil.contains((RefEntity)refElement, (Collection)(currentEntities = new HashSet(currentElements)))) {
                return;
            }
            InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
        }
    }

    private static class RefElementContainer
    implements InspectionRVContentProvider.UserObjectContainer<RefEntity> {
        @NotNull
        private final RefEntity myElement;
        private final CommonProblemDescriptor[] myDescriptors;

        public RefElementContainer(@NotNull RefEntity element, CommonProblemDescriptor[] descriptors) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl$RefElementContainer", "<init>"));
            }
            this.myElement = element;
            this.myDescriptors = descriptors;
        }

        @Nullable
        public RefElementContainer getOwner() {
            RefEntity entity = this.myElement.getOwner();
            if (entity instanceof RefElement) {
                return new RefElementContainer(entity, this.myDescriptors);
            }
            return null;
        }

        @Override
        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl$RefElementContainer", "createNode"));
            }
            RefElementNode refElementNode = new RefElementNode((Object)this.myElement, presentation);
            if (refElementNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl$RefElementContainer", "createNode"));
            }
            return refElementNode;
        }

        @Override
        @NotNull
        public RefEntity getUserObject() {
            RefEntity refEntity = this.myElement;
            if (refEntity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl$RefElementContainer", "getUserObject"));
            }
            return refEntity;
        }

        @Override
        @Nullable
        public String getModule() {
            RefModule refModule = this.myElement instanceof RefElement ? ((RefElement)this.myElement).getModule() : (this.myElement instanceof RefModule ? (RefModule)this.myElement : null);
            return refModule != null ? refModule.getName() : null;
        }

        @Override
        public boolean areEqual(RefEntity o1, RefEntity o2) {
            return Comparing.equal((Object)o1, (Object)o2);
        }

        @Override
        public boolean supportStructure() {
            return this.myElement instanceof RefElement && !(this.myElement instanceof RefDirectory);
        }

        public CommonProblemDescriptor[] getProblemDescriptors() {
            return this.myDescriptors;
        }
    }
}

