/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.ImageObjectRenderer;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ToStringBasedRenderer;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class IconObjectRenderer
extends ToStringBasedRenderer
implements FullValueEvaluatorProvider {
    public IconObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Icon", null, null);
        this.setClassName("javax.swing.Icon");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        String getterName;
        String string = getterName = AllIcons.Debugger.Value.getIconHeight() <= 16 ? "iconToBytesPreviewNormal" : "iconToBytesPreviewRetina";
        if (DebuggerUtilsImpl.isRemote(evaluationContext.getDebugProcess())) {
            return null;
        }
        return ImageObjectRenderer.getIcon(evaluationContext, descriptor.getValue(), getterName);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new ImageObjectRenderer.IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.icon", (Object[])new Object[0]), evaluationContext){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.myEvaluationContext, valueDescriptor.getValue(), "iconToBytes");
            }
        };
    }
}

