/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.TextTransferable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl myFrame;
    private int myUiIndex;
    private String myName;
    private Location myLocation;
    private final XStackFrame myXStackFrame;
    private MethodsTracker.MethodOccurrence myMethodOccurrence;
    private boolean myIsSynthetic;
    private boolean myIsInLibraryContent;
    private ObjectReference myThisObject;
    private Color myBackgroundColor;
    private SourcePosition mySourcePosition;
    private Icon myIcon;

    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame, @NotNull MethodsTracker tracker) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl", "<init>"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl", "<init>"));
        }
        this.myName = null;
        this.myIcon = AllIcons.Debugger.StackFrame;
        this.myFrame = frame;
        try {
            this.myUiIndex = frame.getFrameIndex();
            this.myLocation = frame.location();
            try {
                this.myThisObject = frame.thisObject();
            }
            catch (EvaluateException e) {
                if (!(e.getCause() instanceof InternalException)) {
                    throw e;
                }
                LOG.info((Throwable)e);
            }
            this.myMethodOccurrence = tracker.getMethodOccurrence(this.myUiIndex, this.myLocation.method());
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)this.myMethodOccurrence.getMethod());
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile file;
                    StackFrameDescriptorImpl.this.mySourcePosition = ContextUtil.getSourcePosition(StackFrameDescriptorImpl.this);
                    PsiFile psiFile = file = StackFrameDescriptorImpl.this.mySourcePosition != null ? StackFrameDescriptorImpl.this.mySourcePosition.getFile() : null;
                    if (file == null) {
                        StackFrameDescriptorImpl.this.myIsInLibraryContent = true;
                    } else {
                        StackFrameDescriptorImpl.this.myBackgroundColor = FileColorManager.getInstance((Project)file.getProject()).getFileColor(file);
                        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)StackFrameDescriptorImpl.this.getDebugProcess().getProject()).getFileIndex();
                        VirtualFile vFile = file.getVirtualFile();
                        StackFrameDescriptorImpl.this.myIsInLibraryContent = vFile != null && (projectFileIndex.isInLibraryClasses(vFile) || projectFileIndex.isInLibrarySource(vFile));
                    }
                }
            });
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
            this.myLocation = null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(0, null);
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            this.myLocation = null;
            this.myMethodOccurrence = tracker.getMethodOccurrence(0, null);
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
        }
        this.myXStackFrame = this.myLocation == null ? null : ((DebugProcessImpl)this.getDebugProcess()).getPositionManager().createStackFrame(frame, (DebugProcessImpl)this.getDebugProcess(), this.myLocation);
    }

    @Nullable
    public XStackFrame getXStackFrame() {
        return this.myXStackFrame;
    }

    public int getUiIndex() {
        return this.myUiIndex;
    }

    @NotNull
    public StackFrameProxyImpl getFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.myFrame;
        if (stackFrameProxyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl", "getFrameProxy"));
        }
        return stackFrameProxyImpl;
    }

    @NotNull
    public DebugProcess getDebugProcess() {
        DebugProcess debugProcess = this.myFrame.getVirtualMachine().getDebugProcess();
        if (debugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl", "getDebugProcess"));
        }
        return debugProcess;
    }

    @Override
    public Color getBackgroundColor() {
        return this.myBackgroundColor;
    }

    @Nullable
    public Method getMethod() {
        return this.myMethodOccurrence.getMethod();
    }

    public int getOccurrenceIndex() {
        return this.myMethodOccurrence.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.myMethodOccurrence.isRecursive();
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        XValueMarkers<?, ?> markers;
        XDebugSession session;
        DebugProcess process;
        if (this.myThisObject != null && (process = this.myFrame.getVirtualMachine().getDebugProcess()) instanceof DebugProcessImpl && (session = ((DebugProcessImpl)process).getSession().getXDebugSession()) instanceof XDebugSessionImpl && (markers = ((XDebugSessionImpl)session).getValueMarkers()) != null) {
            return markers.getAllMarkers().get(this.myThisObject);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myXStackFrame != null) {
            TextTransferable.ColoredStringBuilder builder = new TextTransferable.ColoredStringBuilder();
            this.myXStackFrame.customizePresentation((ColoredTextContainer)builder);
            return builder.getBuilder().toString();
        }
        if (this.myLocation == null) {
            return "";
        }
        ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
        StringBuilder label = StringBuilderSpinAllocator.alloc();
        try {
            Method method = this.myMethodOccurrence.getMethod();
            if (method != null) {
                this.myName = method.name();
                label.append(this.myName);
                label.append("()");
            }
            if (settings.SHOW_LINE_NUMBER) {
                String lineNumber;
                try {
                    lineNumber = Integer.toString(this.myLocation.lineNumber());
                }
                catch (InternalError e) {
                    lineNumber = e.toString();
                }
                if (lineNumber != null) {
                    label.append(':');
                    label.append(lineNumber);
                }
            }
            if (settings.SHOW_CLASS_NAME) {
                String name;
                try {
                    ReferenceType refType = this.myLocation.declaringType();
                    name = refType != null ? refType.name() : null;
                }
                catch (InternalError e) {
                    name = e.toString();
                }
                if (name != null) {
                    label.append(", ");
                    int dotIndex = name.lastIndexOf(46);
                    if (dotIndex < 0) {
                        label.append(name);
                    } else {
                        label.append(name.substring(dotIndex + 1));
                        if (settings.SHOW_PACKAGE_NAME) {
                            label.append(" {");
                            label.append(name.substring(0, dotIndex));
                            label.append("}");
                        }
                    }
                }
            }
            if (settings.SHOW_SOURCE_NAME) {
                try {
                    String sourceName;
                    try {
                        sourceName = this.myLocation.sourceName();
                    }
                    catch (InternalError e) {
                        sourceName = e.toString();
                    }
                    label.append(", ");
                    label.append(sourceName);
                }
                catch (AbsentInformationException ignored) {
                    // empty catch block
                }
            }
            String string = label.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)label);
        }
    }

    public final boolean stackFramesEqual(StackFrameDescriptorImpl d) {
        return this.getFrameProxy().equals(d.getFrameProxy());
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl context) {
        this.myIcon = this.calcIcon();
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isInLibraryContent() {
        return this.myIsInLibraryContent;
    }

    public Location getLocation() {
        return this.myLocation;
    }

    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    private Icon calcIcon() {
        try {
            if (this.myFrame.isObsolete()) {
                return AllIcons.Debugger.Db_obsolete;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return EmptyIcon.create((int)6);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public ObjectReference getThisObject() {
        return this.myThisObject;
    }
}

