/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.actions.TogglePresentationModeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.annotations.NotNull;

public class ToggleDistractionFreeModeAction
extends DumbAwareAction {
    private static final String key = "editor.distraction.free.mode";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "update"));
        }
        if (e.getProject() == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        RegistryValue value = Registry.get((String)key);
        boolean selected = value.asBoolean();
        e.getPresentation().setText((selected ? "Exit" : "Enter") + " Distraction Free Mode");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "actionPerformed"));
        }
        Project project = e.getProject();
        RegistryValue value = Registry.get((String)key);
        boolean enter = !value.asBoolean();
        value.setValue(enter);
        if (project == null) {
            return;
        }
        PropertiesComponent p = PropertiesComponent.getInstance();
        UISettings ui = UISettings.getInstance();
        EditorSettingsExternalizable.OptionSet eo = EditorSettingsExternalizable.getInstance().getOptions();
        DaemonCodeAnalyzerSettings ds = DaemonCodeAnalyzerSettings.getInstance();
        String before = "BEFORE.DISTRACTION.MODE.";
        String after = "AFTER.DISTRACTION.MODE.";
        if (enter) {
            ToggleDistractionFreeModeAction.applyAndSave(p, ui, eo, ds, before, after, false);
            TogglePresentationModeAction.storeToolWindows(project);
        } else {
            ToggleDistractionFreeModeAction.applyAndSave(p, ui, eo, ds, after, before, true);
            TogglePresentationModeAction.restoreToolWindows(project, true, false);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
        DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        EditorFactory.getInstance().refreshAllEditors();
    }

    public static void applyAndSave(@NotNull PropertiesComponent p, @NotNull UISettings ui, @NotNull EditorSettingsExternalizable.OptionSet eo, @NotNull DaemonCodeAnalyzerSettings ds, String before, String after, boolean value) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (eo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eo", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        p.setValue(before + "SHOW_STATUS_BAR", String.valueOf(ui.SHOW_STATUS_BAR));
        ui.SHOW_STATUS_BAR = p.getBoolean(after + "SHOW_STATUS_BAR", value);
        p.setValue(before + "SHOW_MAIN_TOOLBAR", String.valueOf(ui.SHOW_MAIN_TOOLBAR));
        ui.SHOW_MAIN_TOOLBAR = p.getBoolean(after + "SHOW_MAIN_TOOLBAR", value);
        p.setValue(before + "SHOW_NAVIGATION_BAR", String.valueOf(ui.SHOW_NAVIGATION_BAR));
        ui.SHOW_NAVIGATION_BAR = p.getBoolean(after + "SHOW_NAVIGATION_BAR", value);
        p.setValue(before + "IS_FOLDING_OUTLINE_SHOWN", String.valueOf(eo.IS_FOLDING_OUTLINE_SHOWN));
        eo.IS_FOLDING_OUTLINE_SHOWN = p.getBoolean(after + "IS_FOLDING_OUTLINE_SHOWN", value);
        p.setValue(before + "IS_WHITESPACES_SHOWN", String.valueOf(eo.IS_WHITESPACES_SHOWN));
        eo.IS_WHITESPACES_SHOWN = p.getBoolean(after + "IS_WHITESPACES_SHOWN", value);
        p.setValue(before + "ARE_LINE_NUMBERS_SHOWN", String.valueOf(eo.ARE_LINE_NUMBERS_SHOWN));
        eo.ARE_LINE_NUMBERS_SHOWN = p.getBoolean(after + "ARE_LINE_NUMBERS_SHOWN", value);
        p.setValue(before + "IS_RIGHT_MARGIN_SHOWN", String.valueOf(eo.IS_RIGHT_MARGIN_SHOWN));
        eo.IS_RIGHT_MARGIN_SHOWN = p.getBoolean(after + "IS_RIGHT_MARGIN_SHOWN", value);
        p.setValue(before + "IS_INDENT_GUIDES_SHOWN", String.valueOf(eo.IS_INDENT_GUIDES_SHOWN));
        eo.IS_INDENT_GUIDES_SHOWN = p.getBoolean(after + "IS_INDENT_GUIDES_SHOWN", value);
        p.setValue(before + "SHOW_METHOD_SEPARATORS", String.valueOf(ds.SHOW_METHOD_SEPARATORS));
        ds.SHOW_METHOD_SEPARATORS = p.getBoolean(after + "SHOW_METHOD_SEPARATORS", value);
        p.setValue(before + "HIDE_TOOL_STRIPES", String.valueOf(ui.HIDE_TOOL_STRIPES));
        ui.HIDE_TOOL_STRIPES = p.getBoolean(after + "HIDE_TOOL_STRIPES", !value);
        p.setValue(before + "EDITOR_TAB_PLACEMENT", String.valueOf(ui.EDITOR_TAB_PLACEMENT));
        ui.EDITOR_TAB_PLACEMENT = p.getOrInitInt(after + "EDITOR_TAB_PLACEMENT", value ? 1 : 0);
    }
}

