/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectWizard
extends AbstractWizard<ModuleWizardStep> {
    protected final WizardContext myWizardContext;

    public AbstractProjectWizard(String title, Project project, String defaultPath) {
        super(title, project);
        this.myWizardContext = AbstractProjectWizard.initContext(project, defaultPath);
    }

    public AbstractProjectWizard(String title, Project project, Component dialogParent) {
        super(title, dialogParent);
        this.myWizardContext = AbstractProjectWizard.initContext(project, null);
    }

    protected String addStepComponent(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        }
        return super.addStepComponent(component);
    }

    public abstract StepSequence getSequence();

    private static WizardContext initContext(@Nullable Project project, @Nullable String defaultPath) {
        WizardContext context = new WizardContext(project);
        if (defaultPath != null) {
            context.setProjectFileDirectory(defaultPath);
            context.setProjectName(defaultPath.substring(FileUtil.toSystemIndependentName((String)defaultPath).lastIndexOf("/") + 1));
        }
        return context;
    }

    @Nullable
    public static Sdk getNewProjectJdk(WizardContext context) {
        if (context.getProjectJdk() != null) {
            return context.getProjectJdk();
        }
        return AbstractProjectWizard.getProjectSdkByDefault(context);
    }

    public static Sdk getProjectSdkByDefault(WizardContext context) {
        Project project = context.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : context.getProject();
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectJdk != null) {
            return projectJdk;
        }
        return null;
    }

    @NotNull
    public String getNewProjectFilePath() {
        if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
            String string = this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".ipr";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/AbstractProjectWizard", "getNewProjectFilePath"));
            }
            return string;
        }
        String string = this.myWizardContext.getProjectFileDirectory();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/AbstractProjectWizard", "getNewProjectFilePath"));
        }
        return string;
    }

    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myWizardContext.getProjectStorageFormat();
        if (storageScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/AbstractProjectWizard", "getStorageScheme"));
        }
        return storageScheme;
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myWizardContext.getProjectBuilder();
    }

    public String getProjectName() {
        return this.myWizardContext.getProjectName();
    }

    @Nullable
    public Sdk getNewProjectJdk() {
        return AbstractProjectWizard.getNewProjectJdk(this.myWizardContext);
    }

    @NotNull
    public String getNewCompileOutput() {
        String projectFilePath = this.myWizardContext.getProjectFileDirectory();
        String path = this.myWizardContext.getCompilerOutputDirectory();
        if (path == null) {
            path = StringUtil.endsWithChar((CharSequence)projectFilePath, (char)'/') ? projectFilePath + "out" : projectFilePath + "/out";
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/AbstractProjectWizard", "getNewCompileOutput"));
        }
        return string;
    }

    protected void updateStep() {
        if (!this.mySteps.isEmpty()) {
            ((ModuleWizardStep)this.getCurrentStepObject()).updateStep();
        }
        super.updateStep();
        this.myIcon.setIcon(null);
    }

    protected void dispose() {
        StepSequence sequence = this.getSequence();
        if (sequence != null) {
            for (ModuleWizardStep step : sequence.getAllSteps()) {
                step.disposeUIResources();
            }
        }
        super.dispose();
    }

    protected final void doOKAction() {
        if (!this.doFinishAction()) {
            return;
        }
        super.doOKAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFinishAction() {
        int idx = this.getCurrentStep();
        try {
            while (true) {
                ModuleWizardStep step;
                if ((step = (ModuleWizardStep)this.mySteps.get(idx)) != this.getCurrentStepObject()) {
                    step.updateStep();
                }
                if (!this.commitStepData(step)) {
                    boolean bl = false;
                    return bl;
                }
                step.onStepLeaving();
                try {
                    step._commit(true);
                }
                catch (CommitStepException e) {
                    this.handleCommitException(e);
                    boolean bl = false;
                    this.myCurrentStep = idx;
                    this.updateStep();
                    return bl;
                }
                if (this.isLastStep(idx)) break;
                idx = this.getNextStep(idx);
            }
            for (ModuleWizardStep wizardStep : this.mySteps) {
                try {
                    wizardStep.onWizardFinished();
                }
                catch (CommitStepException e) {
                    this.handleCommitException(e);
                    boolean bl = false;
                    this.myCurrentStep = idx;
                    this.updateStep();
                    return bl;
                }
            }
        }
        finally {
            this.myCurrentStep = idx;
            this.updateStep();
        }
        return true;
    }

    private void handleCommitException(CommitStepException e) {
        String message = e.getMessage();
        if (message != null) {
            Messages.showErrorDialog((Component)this.getCurrentStepComponent(), (String)message);
        }
    }

    protected boolean commitStepData(ModuleWizardStep step) {
        try {
            if (!step.validate()) {
                return false;
            }
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Component)this.myContentPanel, (String)e.getMessage(), (String)e.getTitle());
            return false;
        }
        step.updateDataModel();
        return true;
    }

    public void doNextAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        if (!this.commitStepData(step)) {
            return;
        }
        step.onStepLeaving();
        super.doNextAction();
    }

    protected String getHelpID() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    public boolean isLast() {
        return this.isLastStep();
    }

    @NonNls
    public String getModuleFilePath() {
        return this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".iml";
    }

    protected void doPreviousAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        step.onStepLeaving();
        super.doPreviousAction();
    }

    public void doCancelAction() {
        ModuleWizardStep step = (ModuleWizardStep)this.getCurrentStepObject();
        step.onStepLeaving();
        super.doCancelAction();
    }

    private boolean isLastStep(int step) {
        return this.getNextStep(step) == step;
    }

    protected final int getNextStep(int step) {
        ModuleWizardStep nextStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            ModuleWizardStep current = (ModuleWizardStep)this.mySteps.get(step);
            nextStep = stepSequence.getNextStep(current);
            while (nextStep != null && !nextStep.isStepVisible()) {
                nextStep = stepSequence.getNextStep(nextStep);
            }
        }
        return nextStep == null ? step : this.mySteps.indexOf(nextStep);
    }

    protected final int getPreviousStep(int step) {
        ModuleWizardStep previousStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            previousStep = stepSequence.getPreviousStep((ModuleWizardStep)this.mySteps.get(step));
            while (previousStep != null && !previousStep.isStepVisible()) {
                previousStep = stepSequence.getPreviousStep(previousStep);
            }
        }
        return previousStep == null ? 0 : this.mySteps.indexOf(previousStep);
    }
}

