/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.newProjectWizard.LoadingProjectTemplate;
import com.intellij.ide.util.newProjectWizard.ProjectTypesList;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectTemplateStep
extends ModuleWizardStep
implements SettingsStep {
    private JBList myTemplatesList;
    private JPanel mySettingsPanel;
    private JTextPane myDescriptionPane;
    private JPanel myDescriptionPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private final HideableDecorator myExpertDecorator;
    private final NamePathComponent myNamePathComponent;
    private final ProjectFormatPanel myFormatPanel;
    private JTextField myModuleName;
    private TextFieldWithBrowseButton myModuleContentRoot;
    private TextFieldWithBrowseButton myModuleFileLocation;
    private JPanel myModulePanel;
    private JPanel myPanel;
    private boolean myModuleNameChangedByUser = false;
    private boolean myModuleNameDocListenerEnabled = true;
    private boolean myContentRootChangedByUser = false;
    private boolean myContentRootDocListenerEnabled = true;
    private boolean myImlLocationChangedByUser = false;
    private boolean myImlLocationDocListenerEnabled = true;
    private final WizardContext myWizardContext;
    private final StepSequence mySequence;
    @Nullable
    private ModuleWizardStep mySettingsStep;
    private final ProjectTypesList myList;
    @Nullable
    private AbstractModuleBuilder myModuleBuilder;

    public SelectTemplateStep(WizardContext context, StepSequence sequence, MultiMap<TemplatesGroup, ProjectTemplate> map) {
        this.myWizardContext = context;
        this.mySequence = sequence;
        this.$$$setupUI$$$();
        Messages.installHyperlinkSupport((JTextPane)this.myDescriptionPane);
        this.myFormatPanel = new ProjectFormatPanel();
        this.myNamePathComponent = NamePathComponent.initNamePathComponent(context);
        if (context.isCreatingNewProject()) {
            this.mySettingsPanel.add((Component)this.myNamePathComponent, "North");
            this.addExpertPanel(this.myModulePanel);
        } else {
            this.mySettingsPanel.add((Component)this.myModulePanel, "North");
        }
        this.bindModuleSettings();
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Mor&e Settings", false);
        this.myExpertPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)20, (int)5, (int)0));
        this.myExpertDecorator.setContentComponent(this.myExpertPanel);
        this.myList = new ProjectTypesList(this.myTemplatesList, map, context);
        this.myList.installKeyAction(this.getNameComponent());
        this.myTemplatesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = SelectTemplateStep.this.getSelectedTemplate();
                boolean loading = template instanceof LoadingProjectTemplate;
                SelectTemplateStep.this.myModuleBuilder = template == null || loading ? null : template.createModuleBuilder();
                SelectTemplateStep.this.setupPanels(template);
                SelectTemplateStep.this.mySequence.setType(SelectTemplateStep.this.myModuleBuilder == null ? null : SelectTemplateStep.this.myModuleBuilder.getBuilderId());
                SelectTemplateStep.this.myWizardContext.requestWizardButtonsUpdate();
            }
        });
        if (this.myWizardContext.isCreatingNewProject()) {
            this.addProjectFormat(this.myModulePanel);
        }
    }

    private JTextField getNameComponent() {
        return this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent.getNameComponent() : this.myModuleName;
    }

    private void addProjectFormat(JPanel panel) {
        SelectTemplateStep.addField("Project \u001bformat:", this.myFormatPanel.getStorageFormatComboBox(), panel);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myList);
    }

    public String getHelpId() {
        WebProjectTemplate webProjectTemplate;
        String subHelpId;
        String helpId = this.myWizardContext.isCreatingNewProject() ? "New_Project_Main_Settings" : "Add_Module_Main_Settings";
        ProjectTemplate projectTemplate = this.getSelectedTemplate();
        if (projectTemplate instanceof WebProjectTemplate && (subHelpId = (webProjectTemplate = (WebProjectTemplate)projectTemplate).getHelpId()) != null) {
            helpId = helpId + ":" + subHelpId;
        }
        return helpId;
    }

    private void setupPanels(@Nullable ProjectTemplate template) {
        SelectTemplateStep.restorePanel(this.myNamePathComponent, 4);
        SelectTemplateStep.restorePanel(this.myModulePanel, this.myWizardContext.isCreatingNewProject() ? 8 : 6);
        SelectTemplateStep.restorePanel(this.myExpertPanel, this.myWizardContext.isCreatingNewProject() ? 1 : 0);
        if (this.mySettingsStep != null) {
            this.mySettingsStep.disposeUIResources();
        }
        this.mySettingsStep = this.myModuleBuilder == null ? null : this.myModuleBuilder.modifySettingsStep((SettingsStep)this);
        String description = null;
        if (template != null && StringUtil.isNotEmpty((String)(description = template.getDescription()))) {
            StringBuilder sb = new StringBuilder("<html><body><font ");
            sb.append(SystemInfo.isMac ? "" : "face=\"Verdana\" size=\"-1\"").append('>');
            sb.append(description).append("</font></body></html>");
            description = sb.toString();
            this.myDescriptionPane.setText(description);
        }
        this.myExpertPlaceholder.setVisible(!(this.myModuleBuilder instanceof TemplateModuleBuilder) && this.myExpertPanel.getComponentCount() > 0);
        for (int i = 0; i < 6; ++i) {
            this.myModulePanel.getComponent(i).setVisible(!(this.myModuleBuilder instanceof EmptyModuleBuilder));
        }
        this.myDescriptionPanel.setVisible(StringUtil.isNotEmpty((String)description));
        this.mySettingsPanel.revalidate();
        this.mySettingsPanel.repaint();
    }

    private static int restorePanel(JPanel component, int i) {
        int removed = 0;
        while (component.getComponentCount() > i) {
            component.remove(component.getComponentCount() - 1);
            ++removed;
        }
        return removed;
    }

    public void updateStep() {
        this.myList.resetSelection();
        this.myExpertDecorator.setOn(SelectTemplateSettings.getInstance().EXPERT_MODE);
    }

    public void onStepLeaving() {
        SelectTemplateSettings settings = SelectTemplateSettings.getInstance();
        settings.EXPERT_MODE = this.myExpertDecorator.isExpanded();
        this.myList.saveSelection();
    }

    public boolean validate() throws ConfigurationException {
        ValidationInfo info;
        ProjectTemplate template = this.getSelectedTemplate();
        if (template == null) {
            throw new ConfigurationException(StringUtil.capitalize((String)ProjectBundle.message((String)"project.new.wizard.from.template.error", (Object[])new Object[]{this.myWizardContext.getPresentationName()})), "Error");
        }
        if (this.myWizardContext.isCreatingNewProject() && !this.myNamePathComponent.validateNameAndPath(this.myWizardContext, this.myFormatPanel.isDefault())) {
            return false;
        }
        if (!this.validateModulePaths()) {
            return false;
        }
        if (!this.myWizardContext.isCreatingNewProject()) {
            this.validateExistingModuleName();
        }
        if ((info = template.validateSettings()) != null) {
            throw new ConfigurationException(info.message, "Error");
        }
        if (this.mySettingsStep != null) {
            return this.mySettingsStep.validate();
        }
        return true;
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        return this.myList.getSelectedTemplate();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameComponent();
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectBuilder((ProjectBuilder)this.myModuleBuilder);
        this.myWizardContext.setProjectName(this.myNamePathComponent.getNameValue());
        this.myWizardContext.setProjectFileDirectory(this.myNamePathComponent.getPath());
        this.myFormatPanel.updateData(this.myWizardContext);
        if (this.myModuleBuilder != null) {
            String moduleName = this.getModuleName();
            this.myModuleBuilder.setName(moduleName);
            this.myModuleBuilder.setModuleFilePath(FileUtil.toSystemIndependentName((String)this.myModuleFileLocation.getText()) + "/" + moduleName + ".iml");
            this.myModuleBuilder.setContentEntryPath(FileUtil.toSystemIndependentName((String)this.getModuleContentRoot()));
            if (this.myModuleBuilder instanceof TemplateModuleBuilder) {
                this.myWizardContext.setProjectStorageFormat(StorageScheme.DIRECTORY_BASED);
            }
        }
        if (this.mySettingsStep != null) {
            this.mySettingsStep.updateDataModel();
        }
    }

    public String getName() {
        return "Template Type";
    }

    public WizardContext getContext() {
        return this.myWizardContext;
    }

    public void addSettingsField(@NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsField"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.myModulePanel;
        SelectTemplateStep.addField(label, field, panel);
    }

    private static void addField(String label, JComponent field, JPanel panel) {
        JBLabel jLabel = new JBLabel(label);
        jLabel.setLabelFor(field);
        panel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)field, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void addSettingsComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addSettingsComponent"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myNamePathComponent : this.myModulePanel;
        panel.add((Component)component, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addExpertPanel(@NotNull JComponent panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertPanel"));
        }
        this.myExpertPanel.add((Component)panel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addExpertField(@NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "addExpertField"));
        }
        JPanel panel = this.myWizardContext.isCreatingNewProject() ? this.myModulePanel : this.myExpertPanel;
        SelectTemplateStep.addField(label, field, panel);
    }

    public void bindModuleSettings() {
        this.myNamePathComponent.getNameComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!SelectTemplateStep.this.myModuleNameChangedByUser) {
                    SelectTemplateStep.this.setModuleName(SelectTemplateStep.this.myNamePathComponent.getNameValue());
                }
            }
        });
        this.myModuleContentRoot.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!SelectTemplateStep.this.myContentRootChangedByUser) {
                    SelectTemplateStep.this.setModuleContentRoot(SelectTemplateStep.this.myNamePathComponent.getPath());
                }
            }
        });
        this.myModuleName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (SelectTemplateStep.this.myModuleNameDocListenerEnabled) {
                    SelectTemplateStep.this.myModuleNameChangedByUser = true;
                }
                String path = SelectTemplateStep.this.getDefaultBaseDir(SelectTemplateStep.this.myWizardContext);
                String moduleName = SelectTemplateStep.this.getModuleName();
                if (path.length() > 0 && !Comparing.strEqual((String)moduleName, (String)SelectTemplateStep.this.myNamePathComponent.getNameValue())) {
                    path = path + "/" + moduleName;
                }
                if (!SelectTemplateStep.this.myContentRootChangedByUser) {
                    boolean f = SelectTemplateStep.this.myModuleNameChangedByUser;
                    SelectTemplateStep.this.myModuleNameChangedByUser = true;
                    SelectTemplateStep.this.setModuleContentRoot(path);
                    SelectTemplateStep.this.myModuleNameChangedByUser = f;
                }
                if (!SelectTemplateStep.this.myImlLocationChangedByUser) {
                    SelectTemplateStep.this.setImlFileLocation(path);
                }
            }
        });
        this.myModuleContentRoot.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (SelectTemplateStep.this.myContentRootDocListenerEnabled) {
                    SelectTemplateStep.this.myContentRootChangedByUser = true;
                }
                if (!SelectTemplateStep.this.myImlLocationChangedByUser) {
                    SelectTemplateStep.this.setImlFileLocation(SelectTemplateStep.this.getModuleContentRoot());
                }
                if (!SelectTemplateStep.this.myModuleNameChangedByUser) {
                    String path = FileUtil.toSystemIndependentName((String)SelectTemplateStep.this.getModuleContentRoot());
                    int idx = path.lastIndexOf("/");
                    boolean f = SelectTemplateStep.this.myContentRootChangedByUser;
                    SelectTemplateStep.this.myContentRootChangedByUser = true;
                    boolean i = SelectTemplateStep.this.myImlLocationChangedByUser;
                    SelectTemplateStep.this.myImlLocationChangedByUser = true;
                    SelectTemplateStep.this.setModuleName(idx >= 0 ? path.substring(idx + 1) : "");
                    SelectTemplateStep.this.myContentRootChangedByUser = f;
                    SelectTemplateStep.this.myImlLocationChangedByUser = i;
                }
            }
        });
        this.myModuleFileLocation.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.file.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.file.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        this.myModuleFileLocation.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (SelectTemplateStep.this.myImlLocationDocListenerEnabled) {
                    SelectTemplateStep.this.myImlLocationChangedByUser = true;
                }
            }
        });
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!SelectTemplateStep.this.myImlLocationChangedByUser) {
                    SelectTemplateStep.this.setImlFileLocation(SelectTemplateStep.this.myNamePathComponent.getPath());
                }
            }
        });
        if (this.myWizardContext.isCreatingNewProject()) {
            this.setModuleName(this.myNamePathComponent.getNameValue());
            this.setModuleContentRoot(this.myNamePathComponent.getPath());
            this.setImlFileLocation(this.myNamePathComponent.getPath());
        } else {
            Project project = this.myWizardContext.getProject();
            assert (project != null);
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir != null) {
                String baseDirPath = baseDir.getPath();
                String moduleName = ProjectWizardUtil.findNonExistingFileName(baseDirPath, "untitled", "");
                String contentRoot = baseDirPath + "/" + moduleName;
                if (!Comparing.strEqual((String)project.getName(), (String)this.myWizardContext.getProjectName()) && !this.myWizardContext.isCreatingNewProject() && this.myWizardContext.getProjectName() != null) {
                    moduleName = ProjectWizardUtil.findNonExistingFileName(this.myWizardContext.getProjectFileDirectory(), this.myWizardContext.getProjectName(), "");
                    contentRoot = this.myWizardContext.getProjectFileDirectory();
                }
                this.setModuleName(moduleName);
                this.setModuleContentRoot(contentRoot);
                this.setImlFileLocation(contentRoot);
                this.myModuleName.select(0, moduleName.length());
            }
        }
    }

    private void validateExistingModuleName() throws ConfigurationException {
        String moduleName = this.getModuleName();
        ProjectStructureConfigurable fromConfigurable = ProjectStructureConfigurable.getInstance(this.myWizardContext.getProject());
        Module module = fromConfigurable != null ? fromConfigurable.getModulesConfig().getModule(moduleName) : ModuleManager.getInstance((Project)this.myWizardContext.getProject()).findModuleByName(moduleName);
        if (module != null) {
            throw new ConfigurationException("Module '" + moduleName + "' already exist in project. Please, specify another name.");
        }
    }

    private boolean validateModulePaths() throws ConfigurationException {
        int answer;
        String moduleName = this.getModuleName();
        String moduleFileDirectory = this.myModuleFileLocation.getText();
        if (moduleFileDirectory.length() == 0) {
            throw new ConfigurationException("Enter module file location");
        }
        if (moduleName.length() == 0) {
            throw new ConfigurationException("Enter a module name");
        }
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.file", (Object[])new Object[0]), moduleFileDirectory, this.myImlLocationChangedByUser)) {
            return false;
        }
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.content.root", (Object[])new Object[0]), this.myModuleContentRoot.getText(), this.myContentRootChangedByUser)) {
            return false;
        }
        File moduleFile = new File(moduleFileDirectory, moduleName + ".iml");
        return !moduleFile.exists() || (answer = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{moduleFile.getAbsolutePath(), IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0])}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0;
    }

    protected String getModuleContentRoot() {
        return this.myModuleContentRoot.getText();
    }

    private String getDefaultBaseDir(WizardContext wizardContext) {
        if (wizardContext.isCreatingNewProject()) {
            return this.myNamePathComponent.getPath();
        }
        Project project = wizardContext.getProject();
        assert (project != null);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            return baseDir.getPath();
        }
        return "";
    }

    private void setImlFileLocation(String path) {
        this.myImlLocationDocListenerEnabled = false;
        this.myModuleFileLocation.setText(FileUtil.toSystemDependentName((String)path));
        this.myImlLocationDocListenerEnabled = true;
    }

    private void setModuleContentRoot(String path) {
        this.myContentRootDocListenerEnabled = false;
        this.myModuleContentRoot.setText(FileUtil.toSystemDependentName((String)path));
        this.myContentRootDocListenerEnabled = true;
    }

    public void setModuleName(String moduleName) {
        this.myModuleNameDocListenerEnabled = false;
        this.myModuleName.setText(moduleName);
        this.myModuleNameDocListenerEnabled = true;
    }

    @NotNull
    public JTextField getModuleNameField() {
        JTextField jTextField = this.myModuleName;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SelectTemplateStep", "getModuleNameField"));
        }
        return jTextField;
    }

    protected String getModuleName() {
        return this.myModuleName.getText().trim();
    }

    public boolean setSelectedTemplate(String group, String name) {
        return this.myList.setSelectedTemplate(group, name);
    }

    @Nullable
    public ModuleWizardStep getSettingsStep() {
        return this.mySettingsStep;
    }

    public Icon getIcon() {
        return this.myWizardContext.getStepIcon();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JTextPane jTextPane;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(5, 5, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Description", (int)0, (int)0, null, null));
        this.myDescriptionPane = jTextPane = new JTextPane();
        jTextPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n  </body>\r\n</html>\r\n");
        jTextPane.setEditable(false);
        jTextPane.setContentType("text/html");
        jPanel5.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(150, 50), null));
        this.myExpertPlaceholder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExpertPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel4.add((Component)jPanel3, "Center");
        this.myModulePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.name.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.myModuleName = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)jTextField, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.root.title"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints3);
        this.myModuleContentRoot = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)textFieldWithBrowseButton2, gridBagConstraints4);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.file.title"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.anchor = 17;
        jPanel2.add((Component)jLabel3, gridBagConstraints5);
        this.myModuleFileLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)textFieldWithBrowseButton, gridBagConstraints6);
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(200, -1), new Dimension(178, 161), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel8.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myTemplatesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

