/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.cmd.CommandLineCompletionProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import groovyjarjarcommonscli.Options;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCompletionProvider
extends CommandLineCompletionProvider {
    private volatile List<LookupElement> myCachedElements;
    private volatile String myCachedWorkingDir;
    private final Project myProject;
    private final ProjectSystemId mySystemId;
    private final TextAccessor myProjectPathAccessor;

    public TaskCompletionProvider(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull TextAccessor workDirectoryField) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        if (workDirectoryField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workDirectoryField", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        this(project, externalSystemId, workDirectoryField, new Options());
    }

    public TaskCompletionProvider(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull TextAccessor workDirectoryField, @NotNull Options options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        if (workDirectoryField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workDirectoryField", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "<init>"));
        }
        super(options);
        this.myProject = project;
        this.mySystemId = externalSystemId;
        this.myProjectPathAccessor = workDirectoryField;
    }

    @Override
    protected void addArgumentVariants(@NotNull CompletionResultSet result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "addArgumentVariants"));
        }
        ArrayList cachedElements = this.myCachedElements;
        String projectPath = this.myProjectPathAccessor.getText();
        if (cachedElements == null || !StringUtil.equals((CharSequence)this.myCachedWorkingDir, (CharSequence)projectPath)) {
            ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)this.mySystemId).getLinkedProjectSettings(projectPath);
            if (linkedProjectSettings == null) {
                return;
            }
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, this.mySystemId, linkedProjectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) {
                return;
            }
            this.myCachedElements = cachedElements = ContainerUtil.newArrayList(this.getVariants((DataNode<ProjectData>)projectData.getExternalProjectStructure(), projectPath));
            this.myCachedWorkingDir = projectPath;
        }
        result.addAllElements(cachedElements);
    }

    protected List<LookupElement> getVariants(@NotNull DataNode<ProjectData> projectDataNode, @NotNull String modulePath) {
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "getVariants"));
        }
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "getVariants"));
        }
        DataNode<ModuleData> moduleDataNode = TaskCompletionProvider.findModuleDataNode(projectDataNode, modulePath);
        if (moduleDataNode == null) {
            return Collections.emptyList();
        }
        Collection tasks = ExternalSystemApiUtil.getChildren(moduleDataNode, (Key)ProjectKeys.TASK);
        ArrayList elements = ContainerUtil.newArrayListWithCapacity((int)tasks.size());
        for (DataNode taskDataNode : tasks) {
            elements.add(LookupElementBuilder.create((String)((TaskData)taskDataNode.getData()).getName()).withIcon(ExternalSystemIcons.Task));
        }
        return elements;
    }

    @Nullable
    public static DataNode<ModuleData> findModuleDataNode(@NotNull DataNode<ProjectData> projectDataNode, final @NotNull String projectPath) {
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "findModuleDataNode"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider", "findModuleDataNode"));
        }
        DataNode node = ExternalSystemApiUtil.findFirstRecursively(projectDataNode, (BooleanFunction)new BooleanFunction<DataNode<?>>(){

            public boolean fun(DataNode<?> node) {
                return node.getKey().equals((Object)ProjectKeys.MODULE) && node.getData() instanceof ModuleData && ((ModuleData)node.getData()).getLinkedExternalProjectPath().equals(projectPath);
            }
        });
        return node;
    }
}

