/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.BitUtil;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWindowAction
extends ToggleAction
implements DumbAware {
    private ProjectWindowAction myPrevious;
    private ProjectWindowAction myNext;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectLocation;

    public ProjectWindowAction(@NotNull String projectName, @NotNull String projectLocation, ProjectWindowAction previous) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/openapi/wm/impl/ProjectWindowAction", "<init>"));
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLocation", "com/intellij/openapi/wm/impl/ProjectWindowAction", "<init>"));
        }
        this.myProjectName = projectName;
        this.myProjectLocation = projectLocation;
        if (previous != null) {
            this.myPrevious = previous;
            this.myNext = previous.myNext;
            this.myNext.myPrevious = this;
            this.myPrevious.myNext = this;
        } else {
            this.myPrevious = this;
            this.myNext = this;
        }
        this.getTemplatePresentation().setText(projectName, false);
    }

    public void dispose() {
        if (this.myPrevious == this) {
            assert (this.myNext == this);
            return;
        }
        if (this.myNext == this) {
            assert (false);
            return;
        }
        this.myPrevious.myNext = this.myNext;
        this.myNext.myPrevious = this.myPrevious;
    }

    public ProjectWindowAction getPrevious() {
        return this.myPrevious;
    }

    public ProjectWindowAction getNext() {
        return this.myNext;
    }

    @NotNull
    public String getProjectLocation() {
        String string = this.myProjectLocation;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ProjectWindowAction", "getProjectLocation"));
        }
        return string;
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ProjectWindowAction", "getProjectName"));
        }
        return string;
    }

    @Nullable
    private Project findProject() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!this.myProjectLocation.equals(project.getPresentableUrl())) continue;
            return project;
        }
        return null;
    }

    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        return this.myProjectLocation.equals(project.getPresentableUrl());
    }

    public void setSelected(@Nullable AnActionEvent e, boolean selected) {
        if (!selected) {
            return;
        }
        Project project = this.findProject();
        if (project == null) {
            return;
        }
        JFrame projectFrame = WindowManager.getInstance().getFrame(project);
        int frameState = projectFrame.getExtendedState();
        if (SystemInfo.isMac && (projectFrame.getExtendedState() & 1) != 0) {
            return;
        }
        if (BitUtil.isSet((int)frameState, (int)1)) {
            projectFrame.setExtendedState(frameState ^ 1);
        }
        projectFrame.toFront();
        projectFrame.requestFocus();
    }

    public String toString() {
        return this.getTemplatePresentation().getText() + " previous: " + this.myPrevious.getTemplatePresentation().getText() + " next: " + this.myNext.getTemplatePresentation().getText();
    }
}

