/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveJavaMemberHandler
implements MoveMemberHandler {
    @Override
    @Nullable
    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(@NotNull PsiMember member, @NotNull PsiReference psiReference, @NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getUsage"));
        }
        if (psiReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getUsage"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getUsage"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getUsage"));
        }
        PsiElement ref = psiReference.getElement();
        if (ref instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
                if (!RefactoringUtil.isInMovedElement((PsiElement)refExpr, membersToMove)) {
                    if (qualifier != null) {
                        return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                    }
                } else if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    @Override
    public void checkConflictsOnUsage(@NotNull MoveMembersProcessor.MoveMembersUsageInfo usageInfo, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnUsage"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnUsage"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnUsage"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnUsage"));
        }
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return;
        }
        PsiMember member = usageInfo.member;
        if (element instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            PsiClass accessObjectClass = null;
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if (!JavaResolveUtil.isAccessible(member, targetClass, modifierListCopy, element, accessObjectClass, null)) {
                String visibility = newVisibility != null ? newVisibility : VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member);
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false), visibility, RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
        }
        if (member instanceof PsiField && targetClass.isInterface()) {
            ReadWriteAccessDetector.Access access;
            ReadWriteAccessDetector accessDetector = ReadWriteAccessDetector.findDetector((PsiElement)member);
            if (accessDetector != null && (access = accessDetector.getExpressionAccess(element)) != ReadWriteAccessDetector.Access.Read) {
                String message = RefactoringUIUtil.getDescription((PsiElement)member, true) + " has write access but is moved to an interface";
                conflicts.putValue((Object)element, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
        } else if (member instanceof PsiField && usageInfo.reference instanceof PsiExpression && member.hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)usageInfo.reference)) && !RefactoringHierarchyUtil.willBeInTargetClass(usageInfo.reference, membersToMove, targetClass, true)) {
            conflicts.putValue((Object)usageInfo.member, (Object)"final variable initializer won't be available after move.");
        }
        PsiReference reference = usageInfo.getReference();
        if (reference != null) {
            RefactoringConflictsUtil.checkAccessibilityConflicts(reference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    @Override
    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnMember"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnMember"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnMember"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "checkConflictsOnMember"));
        }
        if (member instanceof PsiMethod && MoveJavaMemberHandler.hasMethod(targetClass, (PsiMethod)member) || member instanceof PsiField && MoveJavaMemberHandler.hasField(targetClass, (PsiField)member)) {
            String message = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false)});
            conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
        RefactoringConflictsUtil.checkUsedElements(member, (PsiElement)member, membersToMove, null, targetClass, (PsiElement)targetClass, conflicts);
    }

    protected static boolean hasMethod(PsiClass targetClass, PsiMethod method) {
        PsiMethod[] targetClassMethods;
        for (PsiMethod candidate : targetClassMethods = targetClass.getMethods()) {
            if (candidate == method || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)candidate.getSignature(PsiSubstitutor.EMPTY))) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasField(PsiClass targetClass, PsiField field) {
        PsiField[] targetClassFields;
        String fieldName = field.getName();
        for (PsiField candidate : targetClassFields = targetClass.getFields()) {
            if (candidate == field || !fieldName.equals(candidate.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean changeExternalUsage(@NotNull MoveMembersOptions options, @NotNull MoveMembersProcessor.MoveMembersUsageInfo usage) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "changeExternalUsage"));
        }
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "changeExternalUsage"));
        }
        PsiElement element = usage.getElement();
        if (element == null || !element.isValid()) {
            return true;
        }
        if (usage.reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)usage.reference;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) == null) {
                    MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    PsiReferenceParameterList parameterList = refExpr.getParameterList();
                    if (parameterList != null && parameterList.getTypeArguments().length == 0 && !(refExpr instanceof PsiMethodReferenceExpression)) {
                        refExpr.setQualifierExpression(null);
                    } else {
                        Project project = element.getProject();
                        PsiClass targetClass = JavaPsiFacade.getInstance((Project)project).findClass(options.getTargetClassName(), GlobalSearchScope.projectScope((Project)project));
                        if (targetClass != null) {
                            MoveJavaMemberHandler.changeQualifier(refExpr, targetClass, usage.member);
                        }
                    }
                }
            } else if (!(usage.qualifierClass == null || usage.qualifierClass.isEnum() && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) != null)) {
                MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    protected static void changeQualifier(PsiReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (RefactoringUtil.hasOnDemandStaticImport((PsiElement)refExpr, aClass) && !(refExpr instanceof PsiMethodReferenceExpression)) {
            refExpr.setQualifierExpression(null);
        } else if (!ImportsUtil.hasStaticImportOn((PsiElement)refExpr, (PsiMember)member, (boolean)false)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory();
            refExpr.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    @Override
    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiMember memberCopy;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "doMove"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "doMove"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "doMove"));
        }
        if (member instanceof PsiVariable) {
            ((PsiVariable)member).normalizeDeclaration();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)member, true);
        if (options.makeEnumConstant() && member instanceof PsiVariable && EnumConstantsUtil.isSuitableForEnumConstant(((PsiVariable)member).getType(), targetClass)) {
            memberCopy = EnumConstantsUtil.createEnumConstant(targetClass, member.getName(), ((PsiVariable)member).getInitializer());
        } else {
            memberCopy = (PsiMember)member.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = memberCopy.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        }
        member.delete();
        PsiMember psiMember = anchor != null ? (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor) : (PsiMember)targetClass.add((PsiElement)memberCopy);
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "doMove"));
        }
        return psiMember;
    }

    @Override
    public void decodeContextInfo(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "decodeContextInfo"));
        }
        ChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    @Override
    @Nullable
    public PsiElement getAnchor(@NotNull PsiMember member, final @NotNull PsiClass targetClass, final Set<PsiMember> membersToMove) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getAnchor"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler", "getAnchor"));
        }
        if (member instanceof PsiField && member.hasModifierProperty("static")) {
            final ArrayList afterFields = new ArrayList();
            PsiExpression psiExpression = ((PsiField)member).getInitializer();
            if (psiExpression != null) {
                psiExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiField psiField;
                        super.visitReferenceExpression(expression);
                        PsiElement psiElement = expression.resolve();
                        if (psiElement instanceof PsiField && ((psiField = (PsiField)psiElement).getContainingClass() == targetClass || membersToMove.contains(psiField)) && !afterFields.contains(psiField)) {
                            afterFields.add(psiField);
                        }
                    }
                });
            }
            if (!afterFields.isEmpty()) {
                Collections.sort(afterFields, new Comparator<PsiField>(){

                    @Override
                    public int compare(PsiField o1, PsiField o2) {
                        return -PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2);
                    }
                });
                return (PsiElement)afterFields.get(0);
            }
            ArrayList<PsiField> beforeFields = new ArrayList<PsiField>();
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)targetClass))) {
                PsiField fieldWithReference = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiField.class);
                if (fieldWithReference == null || afterFields.contains(fieldWithReference) || fieldWithReference.getContainingClass() != targetClass) continue;
                beforeFields.add(fieldWithReference);
            }
            Collections.sort(beforeFields, PsiUtil.BY_POSITION);
            if (!beforeFields.isEmpty()) {
                return ((PsiField)beforeFields.get(0)).getPrevSibling();
            }
        }
        return null;
    }
}

