/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveMembers.MoveMembersProcessor");
    private PsiClass myTargetClass;
    private final Set<PsiMember> myMembersToMove = new LinkedHashSet<PsiMember>();
    private final MoveCallback myMoveCallback;
    private final boolean myOpenInEditor;
    private String myNewVisibility;
    private String myCommandName = MoveMembersImpl.REFACTORING_NAME;
    private MoveMembersOptions myOptions;

    public MoveMembersProcessor(Project project, MoveMembersOptions options) {
        this(project, null, options);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options) {
        this(project, moveCallback, options, false);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options, boolean openInEditor) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.myOpenInEditor = openInEditor;
        this.setOptions(options);
    }

    @Override
    protected String getCommandName() {
        return this.myCommandName;
    }

    private void setOptions(MoveMembersOptions dialog) {
        this.myOptions = dialog;
        Object[] members = dialog.getSelectedMembers();
        this.myMembersToMove.clear();
        ContainerUtil.addAll(this.myMembersToMove, (Object[])members);
        this.setCommandName((PsiMember[])members);
        this.myTargetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(dialog.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
        this.myNewVisibility = dialog.getMemberVisibility();
    }

    private void setCommandName(PsiMember[] members) {
        StringBuilder commandName = new StringBuilder();
        commandName.append(MoveHandler.REFACTORING_NAME);
        commandName.append(" ");
        boolean first = true;
        for (PsiMember member : members) {
            if (!first) {
                commandName.append(", ");
            }
            commandName.append(UsageViewUtil.getType((PsiElement)member));
            commandName.append(' ');
            commandName.append(UsageViewUtil.getShortName((PsiElement)member));
            first = false;
        }
        this.myCommandName = commandName.toString();
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        MoveMemberViewDescriptor moveMemberViewDescriptor = new MoveMemberViewDescriptor(PsiUtilCore.toPsiElementArray(this.myMembersToMove));
        if (moveMemberViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveMembers/MoveMembersProcessor", "createUsageViewDescriptor"));
        }
        return moveMemberViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MoveMembersUsageInfo> usagesList = new ArrayList<MoveMembersUsageInfo>();
        for (PsiMember member : this.myMembersToMove) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                PsiElement ref = psiReference.getElement();
                MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(ref.getLanguage());
                MoveMembersUsageInfo usage = null;
                if (handler != null && this.myTargetClass != null) {
                    usage = handler.getUsage(member, psiReference, this.myMembersToMove, this.myTargetClass);
                }
                if (usage != null) {
                    usagesList.add(usage);
                    continue;
                }
                if (this.isInMovedElement(ref)) continue;
                usagesList.add(new MoveMembersUsageInfo(member, ref, null, ref, psiReference));
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(new UsageInfo[usagesList.size()]);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages(usageInfos)) == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveMembers/MoveMembersProcessor", "findUsages"));
        }
        return usageInfos;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement resolved : elements) {
            this.myMembersToMove.add((PsiMember)resolved);
        }
    }

    private boolean isInMovedElement(PsiElement element) {
        for (PsiMember member : this.myMembersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            PsiMember item;
            MoveMemberHandler handler;
            PsiClass targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myOptions.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
            if (targetClass == null) {
                return;
            }
            HashMap anchors = new HashMap();
            HashMap anchorsInSourceClass = new HashMap();
            for (PsiMember member : this.myMembersToMove) {
                MoveMemberHandler handler2 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
                if (handler2 == null) continue;
                PsiElement anchor = handler2.getAnchor(member, targetClass, this.myMembersToMove);
                if (anchor instanceof PsiMember && this.myMembersToMove.contains((PsiMember)anchor)) {
                    anchorsInSourceClass.put(member, (PsiMember)anchor);
                    continue;
                }
                anchors.put(member, anchor == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(anchor));
            }
            ArrayList<MoveMembersUsageInfo> otherUsages = new ArrayList<MoveMembersUsageInfo>();
            for (UsageInfo usageInfo : usages) {
                MoveMembersUsageInfo usage = (MoveMembersUsageInfo)usageInfo;
                if (!usage.reference.isValid() || (handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(usageInfo.getElement().getLanguage())) != null && handler.changeExternalUsage(this.myOptions, usage)) continue;
                otherUsages.add(usage);
            }
            HashMap movedMembers = new HashMap();
            for (PsiMember member : this.myMembersToMove) {
                SmartPsiElementPointer pointer;
                PsiMember memberInSourceClass;
                ArrayList<PsiReference> refsToBeRebind = new ArrayList<PsiReference>();
                Iterator iterator = otherUsages.iterator();
                while (iterator.hasNext()) {
                    MoveMembersUsageInfo info = (MoveMembersUsageInfo)((Object)iterator.next());
                    if (!member.equals(info.member)) continue;
                    PsiReference ref = info.getReference();
                    if (ref != null) {
                        refsToBeRebind.add(ref);
                    }
                    iterator.remove();
                }
                RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
                handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
                if (handler == null) continue;
                Object anchor = anchorsInSourceClass.containsKey(member) ? ((memberInSourceClass = (PsiMember)anchorsInSourceClass.get(member)) != null ? (PsiMember)movedMembers.get(memberInSourceClass) : null) : ((pointer = (SmartPsiElementPointer)anchors.get(member)) != null ? pointer.getElement() : null);
                PsiMember newMember = handler.doMove(this.myOptions, member, (PsiElement)anchor, targetClass);
                movedMembers.put(member, newMember);
                elementListener.elementMoved((PsiElement)newMember);
                this.fixModifierList(member, newMember, usages);
                for (PsiReference reference : refsToBeRebind) {
                    reference.bindToElement((PsiElement)newMember);
                }
            }
            MoveMemberHandler handler3 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(this.myTargetClass.getLanguage());
            if (handler3 != null) {
                handler3.decodeContextInfo((PsiElement)this.myTargetClass);
            }
            this.myMembersToMove.clear();
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            if (this.myOpenInEditor && !movedMembers.isEmpty() && (item = (PsiMember)ContainerUtil.getFirstItem(movedMembers.values())) != null) {
                EditorHelper.openInEditor((PsiElement)item);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void fixModifierList(PsiMember member, PsiMember newMember, UsageInfo[] usages) throws IncorrectOperationException {
        PsiModifierList modifierList = newMember.getModifierList();
        if (modifierList != null && this.myTargetClass.isInterface()) {
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            modifierList.setModifierProperty("private", false);
            if (newMember instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            }
            return;
        }
        if (this.myNewVisibility == null) {
            return;
        }
        ArrayList<UsageInfo> filtered = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveMembersUsageInfo) || member != ((MoveMembersUsageInfo)usage).member) continue;
            filtered.add(usage);
        }
        UsageInfo[] infos = filtered.toArray(new UsageInfo[filtered.size()]);
        VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements(infos), (PsiMember)newMember, (String)this.myNewVisibility);
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        String newVisibility = this.myNewVisibility;
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        HashMap modifierListCopies = new HashMap();
        for (PsiMember member : this.myMembersToMove) {
            PsiModifierList modifierListCopy = member.getModifierList();
            if (modifierListCopy != null) {
                modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            }
            if (modifierListCopy != null && newVisibility != null) {
                try {
                    VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            modifierListCopies.put(member, modifierListCopy);
        }
        MoveMembersProcessor.analyzeConflictsOnUsages(usages, this.myMembersToMove, newVisibility, this.myTargetClass, (Map<PsiMember, PsiModifierList>)modifierListCopies, (MultiMap<PsiElement, String>)conflicts);
        MoveMembersProcessor.analyzeConflictsOnMembers(this.myMembersToMove, newVisibility, this.myTargetClass, (Map<PsiMember, PsiModifierList>)modifierListCopies, (MultiMap<PsiElement, String>)conflicts);
        RefactoringConflictsUtil.analyzeModuleConflicts(this.myProject, this.myMembersToMove, usages, (PsiElement)this.myTargetClass, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usages);
    }

    private static void analyzeConflictsOnUsages(UsageInfo[] usages, Set<PsiMember> membersToMove, String newVisibility, PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveMembersUsageInfo)) continue;
            MoveMembersUsageInfo usageInfo = (MoveMembersUsageInfo)usage;
            PsiMember member = usageInfo.member;
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnUsage(usageInfo, newVisibility, modifierListCopies.get(member), targetClass, membersToMove, conflicts);
        }
    }

    private static void analyzeConflictsOnMembers(Set<PsiMember> membersToMove, String newVisibility, PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MultiMap<PsiElement, String> conflicts) {
        for (PsiMember member : membersToMove) {
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnMember(member, newVisibility, modifierListCopies.get(member), targetClass, membersToMove, conflicts);
        }
    }

    @Override
    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.REFACTORING_NAME, (String)message, (String)"refactoring.moveMembers", (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    public List<PsiElement> getMembers() {
        return new ArrayList<PsiMember>(this.myMembersToMove);
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public static class MoveMembersUsageInfo
    extends MoveRenameUsageInfo {
        public final PsiClass qualifierClass;
        public final PsiElement reference;
        public final PsiMember member;

        public MoveMembersUsageInfo(PsiMember member, PsiElement element, PsiClass qualifierClass, PsiElement highlightElement, PsiReference ref) {
            super(highlightElement, ref, (PsiElement)member);
            this.member = member;
            this.qualifierClass = qualifierClass;
            this.reference = element;
        }
    }
}

