/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MissingOverrideAnnotationInspection
extends BaseInspection {
    public boolean ignoreObjectMethods = true;
    public boolean ignoreAnonymousClassMethods = false;

    @NotNull
    public String getID() {
        if ("override" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "getID"));
        }
        return "override";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.equals.hashcode.and.tostring", new Object[0]), "ignoreObjectMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.in.anonymous.classes", new Object[0]), "ignoreAnonymousClassMethods");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MissingOverrideAnnotationFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    private class MissingOverrideAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingOverrideAnnotationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return;
            }
            if (MissingOverrideAnnotationInspection.this.ignoreAnonymousClassMethods && methodClass instanceof PsiAnonymousClass) {
                return;
            }
            boolean useJdk6Rules = PsiUtil.isLanguageLevel6OrHigher((PsiElement)method);
            if (useJdk6Rules ? !this.isJdk6Override(method, methodClass) : !this.isJdk5Override(method, methodClass)) {
                return;
            }
            if (MissingOverrideAnnotationInspection.this.ignoreObjectMethods && (MethodUtils.isHashCode(method) || MethodUtils.isEquals(method) || MethodUtils.isToString(method))) {
                return;
            }
            if (this.hasOverrideAnnotation((PsiModifierListOwner)method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean hasOverrideAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation annotation = modifierList.findAnnotation("java.lang.Override");
            return annotation != null;
        }

        private boolean isJdk6Override(PsiMethod method, PsiClass methodClass) {
            PsiMethod[] superMethods = this.getSuperMethodsInJavaSense(method, methodClass);
            if (superMethods.length <= 0) {
                return false;
            }
            if (!methodClass.isInterface()) {
                return true;
            }
            for (PsiMethod superMethod : superMethods) {
                if (superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return false;
        }

        private boolean isJdk5Override(PsiMethod method, PsiClass methodClass) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = this.getSuperMethodsInJavaSense(method, methodClass)) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || superClass.isInterface() || methodClass.isInterface() && superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return false;
        }

        private PsiMethod[] getSuperMethodsInJavaSense(@NotNull PsiMethod method, @NotNull PsiClass methodClass) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor", "getSuperMethodsInJavaSense"));
            }
            if (methodClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodClass", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor", "getSuperMethodsInJavaSense"));
            }
            PsiMethod[] superMethods = method.findSuperMethods();
            SmartList toExclude = new SmartList();
            for (PsiMethod superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)superClass, (boolean)true)) continue;
                toExclude.add(superMethod);
            }
            if (!toExclude.isEmpty()) {
                ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(Arrays.asList(superMethods));
                result.removeAll((Collection<?>)toExclude);
                return result.toArray(new PsiMethod[result.size()]);
            }
            return superMethods;
        }
    }

    private static class MissingOverrideAnnotationFix
    extends InspectionGadgetsFix {
        private MissingOverrideAnnotationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("missing.override.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (!(parent instanceof PsiModifierListOwner)) {
                return;
            }
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)parent;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Override", (PsiElement)modifierListOwner);
            PsiModifierList modifierList = modifierListOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }
    }
}

