/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.MakeMethodVarargsPredicate;
import org.jetbrains.annotations.NotNull;

public class MakeMethodVarargsIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + MakeMethodVarargsIntention.class.getName()));

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MakeMethodVarargsPredicate makeMethodVarargsPredicate = new MakeMethodVarargsPredicate();
        if (makeMethodVarargsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/varargs/MakeMethodVarargsIntention", "getElementPredicate"));
        }
        return makeMethodVarargsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/varargs/MakeMethodVarargsIntention", "processIntention"));
        }
        MakeMethodVarargsIntention.makeMethodVarargs(element);
        MakeMethodVarargsIntention.makeMethodCallsVarargs(element);
    }

    private static void makeMethodVarargs(PsiElement element) throws IncorrectOperationException {
        PsiParameterList parameterList = (PsiParameterList)element;
        PsiParameter[] parameters = parameterList.getParameters();
        PsiParameter lastParameter = parameters[parameters.length - 1];
        PsiType type = lastParameter.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
        PsiTypeElement typeElement = lastParameter.getTypeElement();
        LOG.assertTrue(typeElement != null);
        PsiType ellipsisType = PsiEllipsisType.createEllipsis((PsiType)((PsiArrayType)type).getComponentType(), (PsiAnnotation[])type.getAnnotations());
        typeElement.replace((PsiElement)factory.createTypeElement(ellipsisType));
    }

    private static void makeMethodCallsVarargs(PsiElement element) throws IncorrectOperationException {
        PsiMethod method = (PsiMethod)element.getParent();
        Query query = ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope(), (boolean)false);
        for (PsiReference reference : query) {
            PsiExpression[] initializers;
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiExpression lastArgument;
            PsiReferenceExpression referenceExpression;
            PsiMethodCallExpression methodCallExpression;
            PsiExpressionList argumentList;
            PsiExpression[] arguments;
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiReferenceExpression) || (arguments = (argumentList = (methodCallExpression = (PsiMethodCallExpression)(referenceExpression = (PsiReferenceExpression)referenceElement).getParent()).getArgumentList()).getExpressions()).length == 0 || !((lastArgument = arguments[arguments.length - 1]) instanceof PsiNewExpression) || (arrayInitializerExpression = (newExpression = (PsiNewExpression)lastArgument).getArrayInitializer()) == null) continue;
            for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
                argumentList.add((PsiElement)initializer);
            }
            lastArgument.delete();
        }
    }
}

