/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class DeleteDeviceAction
extends DeviceUiAction {
    public DeleteDeviceAction(@NotNull DeviceUiAction.DeviceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/avdmanager/DeleteDeviceAction", "<init>"));
        }
        super(provider, "Delete");
    }

    @Override
    public boolean isEnabled() {
        Device device = this.myProvider.getDevice();
        return device != null && DeviceManagerConnection.getDefaultDeviceManagerConnection().isUserDevice(device);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Device device = this.myProvider.getDevice();
        int result = JOptionPane.showConfirmDialog(null, "Do you really want to delete Device " + device.getDisplayName() + "?", "Confirm Deletion", 0);
        if (result == 0) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().deleteDevice(device);
            this.myProvider.refreshDevices();
            this.myProvider.selectDefaultDevice();
        }
    }
}

