/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.editors.hprof.HprofViewPanel;
import com.android.tools.perflib.heap.Snapshot;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofEditor
extends UserDataHolderBase
implements FileEditor {
    private final HprofViewPanel myHprofViewPanel;

    public HprofEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        this.myHprofViewPanel = new HprofViewPanel(project);
        this.parseHprofFileInBackground(project, file);
    }

    private void parseHprofFileInBackground(final Project project, final VirtualFile file) {
        final Task.Modal parseTask = new Task.Modal(project, "Parsing hprof file", false){
            private String myErrorMessage;
            private Snapshot mySnapshot;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/hprof/HprofEditor$1", "run"));
                }
                indicator.setIndeterminate(true);
                File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    this.mySnapshot = new Snapshot(null);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.myErrorMessage = "Unexpected error while parsing hprof file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    throw new ProcessCanceledException();
                }
            }

            public void onSuccess() {
                HprofEditor.this.myHprofViewPanel.setSnapshot(this.mySnapshot);
            }

            public void onCancel() {
                Messages.showErrorDialog((Project)project, (String)this.myErrorMessage, (String)HprofEditor.this.getName());
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHprofViewPanel.getComponent();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("HprofView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getName"));
        }
        return "HprofView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/hprof/HprofEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/hprof/HprofEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

