/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.model.dsl.internal.inputs.RuleInputAccessBacking;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClosureBackedModelMutator
implements ModelMutator<Object> {
    private final Closure<?> action;
    private final List<ModelReference<?>> inputReferences;
    private final ModelPath modelPath;
    private final SourceLocation sourceLocation;

    public ClosureBackedModelMutator(Closure<?> action, List<ModelReference<?>> inputReferences, ModelPath modelPath, SourceLocation sourceLocation) {
        this.action = action;
        this.inputReferences = inputReferences;
        this.modelPath = modelPath;
        this.sourceLocation = sourceLocation;
    }

    public ModelReference<Object> getSubject() {
        return ModelReference.untyped((ModelPath)this.modelPath);
    }

    public void mutate(final Object object, Inputs inputs) {
        RuleInputAccessBacking.runWithContext(inputs, new Runnable(){

            public void run() {
                new ClosureBackedAction(ClosureBackedModelMutator.this.action).execute(object);
            }
        });
    }

    public ModelRuleDescriptor getDescriptor() {
        String descriptor = String.format("model.%s @ %s", this.modelPath, this.sourceLocation);
        return new SimpleModelRuleDescriptor(descriptor);
    }

    public List<ModelReference<?>> getInputs() {
        return this.inputReferences;
    }
}

