/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceCycleDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue CYCLE = Issue.create("ResourceCycle", "Cycle in resource definitions", "There should be no cycles in resource definitions as this can lead to runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    public static final Issue CRASH = Issue.create("AaptCrash", "Potential AAPT crash", "Defining a style which sets `android:id` to a dynamically generated id can cause many versions of `aapt`, the resource packaging tool, to crash. To work around this, declare the id explicitly with `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION).addMoreInfo("https://code.google.com/p/android/issues/detail?id=20479");
    private Map<ResourceType, Multimap<String, String>> mReferences;
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    private Map<ResourceType, List<List<String>>> mChains;

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        if (context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "style", "color", "item");
    }

    private void recordReference(@NonNull ResourceType type, @NonNull String from, @NonNull String to) {
        int index;
        if (to.isEmpty() || to.startsWith("@android:")) {
            return;
        }
        assert (this.mReferences != null);
        ListMultimap map = this.mReferences.get(type);
        if (map == null) {
            map = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<String>>(){

                public List<String> get() {
                    return Lists.newArrayListWithExpectedSize((int)6);
                }
            });
            this.mReferences.put(type, (Multimap<String, String>)map);
        }
        if (to.charAt(0) == '@' && (index = to.indexOf(47)) != -1) {
            to = to.substring(index + 1);
        }
        map.put((Object)from, (Object)to);
    }

    private void recordLocation(@NonNull XmlContext context, @NonNull Node node, @NonNull ResourceType type, @NonNull String from) {
        assert (this.mLocations != null);
        ArrayListMultimap map = this.mLocations.get(type);
        if (map == null) {
            map = ArrayListMultimap.create((int)30, (int)4);
            this.mLocations.put(type, (Multimap<String, Location>)map);
        }
        Location location = context.getLocation(node);
        map.put((Object)from, (Object)location);
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        block34: {
            String tagName;
            block37: {
                String layout;
                block36: {
                    int index;
                    String name;
                    block32: {
                        String drawable;
                        ResourceFolderType folderType;
                        block35: {
                            block33: {
                                tagName = element.getTagName();
                                if (!tagName.equals("item")) break block32;
                                if (this.mReferences == null) {
                                    return;
                                }
                                folderType = context.getResourceFolderType();
                                if (folderType != ResourceFolderType.VALUES) break block33;
                                Attr typeNode = element.getAttributeNode("type");
                                if (typeNode == null) break block34;
                                String typeName = typeNode.getValue();
                                ResourceType type = ResourceType.getEnum((String)typeName);
                                Attr nameNode = element.getAttributeNode("name");
                                if (type != null && nameNode != null) {
                                    NodeList childNodes = element.getChildNodes();
                                    int n = childNodes.getLength();
                                    for (int i = 0; i < n; ++i) {
                                        char c;
                                        Node child = childNodes.item(i);
                                        if (child.getNodeType() != 3) continue;
                                        String text = child.getNodeValue();
                                        int max = text.length();
                                        for (int k = 0; k < max && !Character.isWhitespace(c = text.charAt(k)) && c == '@' && text.startsWith(type.getName(), k + 1); ++k) {
                                            String to = text.trim();
                                            if (this.mReferences == null) continue;
                                            String name2 = nameNode.getValue();
                                            if (this.mLocations != null) {
                                                this.recordLocation(context, child, type, name2);
                                                continue;
                                            }
                                            this.recordReference(type, name2, to);
                                        }
                                    }
                                }
                                break block34;
                            }
                            if (folderType != ResourceFolderType.COLOR) break block35;
                            String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                            if (color == null || !color.startsWith("@color/")) break block34;
                            String currentColor = LintUtils.getBaseName(context.file.getName());
                            if (this.mLocations != null) {
                                this.recordLocation(context, element, ResourceType.COLOR, currentColor);
                            } else {
                                this.recordReference(ResourceType.COLOR, currentColor, color.substring("@color/".length()));
                            }
                            break block34;
                        }
                        if (folderType != ResourceFolderType.DRAWABLE || (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) == null || !drawable.startsWith("@drawable/")) break block34;
                        String currentColor = LintUtils.getBaseName(context.file.getName());
                        if (this.mLocations != null) {
                            this.recordLocation(context, element, ResourceType.DRAWABLE, currentColor);
                        } else {
                            this.recordReference(ResourceType.DRAWABLE, currentColor, drawable.substring("@drawable/".length()));
                        }
                        break block34;
                    }
                    if (!tagName.equals("style")) break block36;
                    Attr nameNode = element.getAttributeNode("name");
                    Attr parentNode = element.getAttributeNode("parent");
                    if (parentNode != null && nameNode != null) {
                        name = nameNode.getValue();
                        String parent = parentNode.getValue();
                        if (parent.endsWith(name) && parent.equals("@style/" + name) && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                            context.report(CYCLE, parentNode, context.getLocation(parentNode), String.format("Style `%1$s` should not extend itself", name));
                        } else if (parent.startsWith("@style/") && parent.startsWith(name, "@style/".length()) && parent.startsWith(".", "@style/".length() + name.length()) && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                            context.report(CYCLE, parentNode, context.getLocation(parentNode), String.format("Potential cycle: `%1$s` is the implied parent of `%2$s` and this defines the opposite", name, parent.substring("@style/".length())));
                            return;
                        }
                        if (this.mReferences != null && !parent.isEmpty()) {
                            if (this.mLocations != null) {
                                this.recordLocation(context, parentNode, ResourceType.STYLE, name);
                            } else {
                                this.recordReference(ResourceType.STYLE, name, parent);
                            }
                        }
                    } else if (this.mReferences != null && nameNode != null && (index = (name = nameNode.getValue()).lastIndexOf(46)) > 0) {
                        String parent = name.substring(0, index);
                        if (this.mReferences != null) {
                            if (this.mLocations != null) {
                                Attr node = element.getAttributeNode("name");
                                this.recordLocation(context, node, ResourceType.STYLE, name);
                            } else {
                                this.recordReference(ResourceType.STYLE, name, parent);
                            }
                        }
                    }
                    if (!context.isEnabled(CRASH) || context.getDriver().getPhase() != 1) break block34;
                    for (Element item : LintUtils.getChildren(element)) {
                        if (!"android:id".equals(item.getAttribute("name"))) continue;
                        ResourceCycleDetector.checkCrashItem(context, item);
                    }
                    break block34;
                }
                if (!tagName.equals("include")) break block37;
                Attr layoutNode = element.getAttributeNode("layout");
                if (layoutNode == null || !(layout = layoutNode.getValue()).startsWith("@layout/")) break block34;
                String currentLayout = LintUtils.getBaseName(context.file.getName());
                if (this.mReferences != null) {
                    if (this.mLocations != null) {
                        this.recordLocation(context, layoutNode, ResourceType.LAYOUT, currentLayout);
                    } else {
                        this.recordReference(ResourceType.LAYOUT, currentLayout, layout);
                    }
                }
                if (layout.startsWith(currentLayout, "@layout/".length()) && layout.length() == currentLayout.length() + "@layout/".length() && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                    String message = String.format("Layout `%1$s` should not include itself", currentLayout);
                    context.report(CYCLE, layoutNode, context.getLocation(layoutNode), message);
                }
                break block34;
            }
            if (tagName.equals("color")) {
                NodeList childNodes = element.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    char c;
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 3) continue;
                    String text = child.getNodeValue();
                    int max = text.length();
                    for (int k = 0; k < max && !Character.isWhitespace(c = text.charAt(k)) && text.startsWith("@color/", k); ++k) {
                        String color = text.trim().substring("@color/".length());
                        String name = element.getAttribute("name");
                        if (this.mReferences != null) {
                            if (this.mLocations != null) {
                                this.recordLocation(context, child, ResourceType.COLOR, name);
                            } else {
                                this.recordReference(ResourceType.COLOR, name, color);
                            }
                        }
                        if (!color.equals(name) || !context.isEnabled(CYCLE) || context.getDriver().getPhase() != 1) continue;
                        context.report(CYCLE, child, context.getLocation(child), String.format("Color `%1$s` should not reference itself", color));
                    }
                }
            }
        }
    }

    private static void checkCrashItem(@NonNull XmlContext context, @NonNull Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int max = text.length();
            for (int k = 0; k < max; ++k) {
                char c = text.charAt(k);
                if (Character.isWhitespace(c)) {
                    return;
                }
                if (!text.startsWith("@+id/", k)) {
                    return;
                }
                String name = text.trim().substring("@+id/".length());
                String message = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define " + "the id explicitly using " + "`<item type=\"id\" name=\"" + name + "\"/>` instead.";
                context.report(CRASH, item, context.getLocation(item), message);
            }
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mReferences == null) {
            return;
        }
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            for (Map.Entry<ResourceType, Multimap<String, String>> entry : this.mReferences.entrySet()) {
                ResourceType type = entry.getKey();
                Multimap<String, String> map = entry.getValue();
                this.findCycles(context, type, map);
            }
        } else {
            assert (phase == 2);
            for (Map.Entry<ResourceType, List<List<String>>> entry : this.mChains.entrySet()) {
                ResourceType type = entry.getKey();
                ArrayListMultimap locations = this.mLocations.get(type);
                if (locations == null) {
                    locations = ArrayListMultimap.create();
                }
                List<List<String>> chains = entry.getValue();
                for (List<String> chain : chains) {
                    Location location = null;
                    assert (!chain.isEmpty());
                    int n = chain.size();
                    for (int i = 0; i < n; ++i) {
                        String item = chain.get(i);
                        Collection itemLocations = locations.get((Object)item);
                        if (itemLocations.isEmpty()) continue;
                        Location itemLocation = (Location)itemLocations.iterator().next();
                        String next = chain.get((i + 1) % chain.size());
                        String label = "Reference from @" + type.getName() + "/" + item + " to " + type.getName() + "/" + next + " here";
                        itemLocation.setMessage(label);
                        itemLocation.setSecondary(location);
                        location = itemLocation;
                    }
                    if (location == null) {
                        location = Location.create(context.getProject().getDir());
                    } else {
                        Location curr = location.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location) {
                                curr.setSecondary(null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    String message = String.format("%1$s Resource definition cycle: %2$s", type.getDisplayName(), Joiner.on((String)" => ").join(chain));
                    context.report(CYCLE, location, message);
                }
            }
        }
    }

    private void findCycles(@NonNull Context context, @NonNull ResourceType type, @NonNull Multimap<String, String> map) {
        HashSet visiting = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map.size());
        for (String from : map.keySet()) {
            ArrayList list;
            List<String> chain;
            if (seen.contains(from) || (chain = ResourceCycleDetector.dfs(map, from, visiting)) == null || chain.size() <= 2) continue;
            seen.addAll(chain);
            Collections.reverse(chain);
            if (this.mChains == null) {
                this.mChains = Maps.newEnumMap(ResourceType.class);
                this.mLocations = Maps.newEnumMap(ResourceType.class);
                context.getDriver().requestRepeat(this, Scope.RESOURCE_FILE_SCOPE);
            }
            if ((list = this.mChains.get(type)) == null) {
                list = Lists.newArrayList();
                this.mChains.put(type, list);
            }
            list.add(chain);
        }
    }

    @Nullable
    private static List<String> dfs(@NonNull Multimap<String, String> map, @NonNull String from, @NonNull Set<String> visiting) {
        visiting.add(from);
        Collection targets = map.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target : targets) {
                List<Object> chain;
                if (visiting.contains(target)) {
                    chain = Lists.newArrayList();
                    chain.add(target);
                    chain.add(from);
                    return chain;
                }
                chain = ResourceCycleDetector.dfs(map, target, visiting);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }
}

